/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.mapMsgQueue;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MapMsgQueueTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.mapMsgQueue.MapMsgQueueTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(MapMsgQueueTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String password;
    String mode;
    String user;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning: ", (Throwable)e);
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void mapMessageFullMsgQTest() throws Exception {
        boolean pass = true;
        boolean booleanValue = false;
        byte byteValue = 127;
        byte[] bytesValue = new byte[]{127, -127, 1, 0};
        byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
        char charValue = 'Z';
        double doubleValue = 6.02E23;
        float floatValue = 6.02E23f;
        int intValue = Integer.MAX_VALUE;
        long longValue = Long.MAX_VALUE;
        short shortValue = Short.MAX_VALUE;
        String stringValue = "Map Message Test";
        Integer integerValue = 100;
        String initial = "spring is here!";
        try {
            byte[] b;
            MapMessage messageSentMapMessage = null;
            MapMessage messageReceivedMapMessage = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentMapMessage = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageFullMsgQTest");
            messageSentMapMessage.setBoolean("booleanValue", booleanValue);
            messageSentMapMessage.setByte("byteValue", byteValue);
            messageSentMapMessage.setBytes("bytesValue", bytesValue);
            messageSentMapMessage.setBytes("bytesValue2", bytesValue, 0, 1);
            messageSentMapMessage.setChar("charValue", charValue);
            messageSentMapMessage.setDouble("doubleValue", doubleValue);
            messageSentMapMessage.setFloat("floatValue", floatValue);
            messageSentMapMessage.setInt("intValue", intValue);
            messageSentMapMessage.setLong("longValue", longValue);
            messageSentMapMessage.setObject("integerValue", (Object)integerValue);
            messageSentMapMessage.setShort("shortValue", shortValue);
            messageSentMapMessage.setString("stringValue", stringValue);
            messageSentMapMessage.setString("nullTest", null);
            this.tool.getDefaultQueueSender().send((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            Enumeration list = messageReceivedMapMessage.getMapNames();
            String name = null;
            int it = 0;
            int j = 0;
            while (list.hasMoreElements()) {
                name = (String)list.nextElement();
                logger.log(System.Logger.Level.TRACE, "Object with name: " + name);
                ++it;
                if (name.equals("booleanValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("byteValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("bytesValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("bytesValue2")) {
                    ++j;
                    continue;
                }
                if (name.equals("charValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("doubleValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("floatValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("intValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("longValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("integerValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("shortValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("stringValue")) {
                    ++j;
                    continue;
                }
                if (name.equals("nullTest")) {
                    ++j;
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "Object not created by the test with name: " + name);
            }
            if (it < 13 || j < 13) {
                logger.log(System.Logger.Level.ERROR, "Incorrect number of of Objects. Total number = " + it + " Total created by the test = " + j);
            }
            try {
                if (messageReceivedMapMessage.itemExists("booleanValue")) {
                    if (messageReceivedMapMessage.getBoolean("booleanValue") != booleanValue) {
                        logger.log(System.Logger.Level.ERROR, "Error: Invalid boolean returned=" + messageReceivedMapMessage.getBoolean("booleanValue"));
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name booleanValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception was returned: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("byteValue")) {
                    if (messageReceivedMapMessage.getByte("byteValue") != byteValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid byte returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name byteValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception was returned: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("bytesValue")) {
                    b = messageReceivedMapMessage.getBytes("bytesValue");
                    for (int i = 0; i < b.length; ++i) {
                        if (b[i] == bytesValue[i]) continue;
                        logger.log(System.Logger.Level.ERROR, "Fail: byte array " + i + " not valid");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name bytesValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("bytesValue2")) {
                    b = messageReceivedMapMessage.getBytes("bytesValue2");
                    if (b[0] != bytesValue[0]) {
                        logger.log(System.Logger.Level.ERROR, "Fail: byte array not valid");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name bytesValue2 exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("charValue")) {
                    if (messageReceivedMapMessage.getChar("charValue") != charValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid char returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name charValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("doubleValue")) {
                    if (messageReceivedMapMessage.getDouble("doubleValue") != doubleValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid double returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name doubleValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("floatValue")) {
                    if (messageReceivedMapMessage.getFloat("floatValue") != floatValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid float returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name floatValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("intValue")) {
                    if (messageReceivedMapMessage.getInt("intValue") != intValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid int returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name intValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("longValue")) {
                    if (messageReceivedMapMessage.getLong("longValue") != longValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid long returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name longValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("integerValue")) {
                    if (!messageReceivedMapMessage.getObject("integerValue").toString().equals(integerValue.toString())) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid object returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name integerValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("shortValue")) {
                    if (messageReceivedMapMessage.getShort("shortValue") != shortValue) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid short returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name shortValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("stringValue")) {
                    if (!messageReceivedMapMessage.getString("stringValue").equals(stringValue)) {
                        logger.log(System.Logger.Level.ERROR, "Fail: invalid string returned");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name stringValue exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("nullTest")) {
                    if (messageReceivedMapMessage.getString("nullTest") != null) {
                        logger.log(System.Logger.Level.ERROR, "Fail:  null not returned from getString");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Error: No Object with name nullTest exists");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.itemExists("nullTestxyz")) {
                    logger.log(System.Logger.Level.ERROR, "Fail:  field with name nullTestxyz is unset");
                    pass = false;
                } else if (messageReceivedMapMessage.getObject("nullTestxyz") != null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error: field with name nullTestxyz  should be null");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: mapMessageFullMsgQTest test failure");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("mapMessageFullMsgQTest");
        }
    }

    @Test
    public void MapMessageConversionQTestsBoolean() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean booleanValue = true;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsBoolean");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setBoolean("booleanValue", booleanValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a boolean");
            try {
                if (messageReceived.getBoolean("booleanValue") == booleanValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to boolean - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a boolean");
            try {
                String tmp = messageReceived.getString("booleanValue");
                if (Boolean.valueOf(booleanValue).toString().equals(tmp)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to string - valid");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: wrong value returned=" + tmp + ".");
                    logger.log(System.Logger.Level.ERROR, "Expecting " + Boolean.valueOf(booleanValue) + ".");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                byte[] b = messageReceived.getBytes("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a boolean - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a boolean - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a boolean - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a boolean - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a boolean - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a boolean - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a boolean - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("booleanValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsBoolean", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsByte() throws Exception {
        MapMessage messageSent = null;
        MapMessage messageReceived = null;
        byte byteValue = 127;
        boolean pass = true;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsByte");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setByte("byteValue", byteValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a byte - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("byteValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a byte");
            try {
                if (messageReceived.getString("byteValue").equals(Byte.toString(byteValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read a byte - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("byteValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a byte");
            try {
                if (messageReceived.getByte("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to byte - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a byte");
            try {
                if (messageReceived.getShort("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to short - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a boolean - this is not valid");
            try {
                char c = messageReceived.getChar("byteValue");
                pass = false;
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a byte");
            try {
                if (messageReceived.getInt("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to int - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a byte");
            try {
                if (messageReceived.getLong("byteValue") == (long)byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a boolean - this is not valid");
            try {
                float f = messageReceived.getFloat("byteValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a boolean - this is not valid");
            try {
                double d = messageReceived.getDouble("byteValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsByte", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsShort() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            short shortValue = 1;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsShort");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setShort("shortValue", shortValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a short - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("shortValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a short");
            try {
                if (messageReceived.getString("shortValue").equals(Short.toString(shortValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read a short - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("shortValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a short - this is not valid");
            try {
                byte b = messageReceived.getByte("shortValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a short");
            try {
                if (messageReceived.getShort("shortValue") == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to short - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a short - this is not valid");
            try {
                char c = messageReceived.getChar("shortValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a short");
            try {
                if (messageReceived.getInt("shortValue") == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to int - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a short");
            try {
                if (messageReceived.getLong("shortValue") == (long)shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a short - this is not valid");
            try {
                float f = messageReceived.getFloat("shortValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a short - this is not valid");
            try {
                double d = messageReceived.getDouble("shortValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsShort", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsChar() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            char charValue = 'a';
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsChar");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setChar("charValue", charValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a char - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a char");
            try {
                if (messageReceived.getString("charValue").equals(Character.valueOf(charValue).toString())) {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read a char - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a char - this is not valid");
            try {
                byte b = messageReceived.getByte("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a char");
            try {
                short s = messageReceived.getShort("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a char ");
            try {
                if (messageReceived.getChar("charValue") == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to char - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a char ");
            try {
                int i = messageReceived.getInt("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a char");
            try {
                long l = messageReceived.getLong("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a char - this is not valid");
            try {
                float f = messageReceived.getFloat("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a char - this is not valid");
            try {
                double d = messageReceived.getDouble("charValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsChar", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsInt() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            int intValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsInt");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setInt("intValue", intValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read an int - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read an int");
            try {
                if (messageReceived.getString("intValue").equals(Integer.toString(intValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read an int - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read an int - this is not valid");
            try {
                byte b = messageReceived.getByte("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read an int");
            try {
                short s = messageReceived.getShort("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read an int - this is not valid");
            try {
                char c = messageReceived.getChar("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read an int");
            try {
                if (messageReceived.getInt("intValue") == intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to int - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read an int");
            try {
                if (messageReceived.getLong("intValue") == (long)intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read an int - this is not valid");
            try {
                float f = messageReceived.getFloat("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read an int - this is not valid");
            try {
                double d = messageReceived.getDouble("intValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsInt", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsLong() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            long longValue = 2L;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsLong");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setLong("longValue", longValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a long - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a long");
            try {
                if (messageReceived.getString("longValue").equals(Long.toString(longValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: long to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read  a long - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read an long - this is not valid");
            try {
                byte b = messageReceived.getByte("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a long");
            try {
                short s = messageReceived.getShort("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a long - this is not valid");
            try {
                char c = messageReceived.getChar("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a long");
            try {
                int i = messageReceived.getInt("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a long");
            try {
                if (messageReceived.getLong("longValue") == longValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a long - this is not valid");
            try {
                float f = messageReceived.getFloat("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a long ");
            try {
                double d = messageReceived.getDouble("longValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsLong", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsFloat() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            float floatValue = 5.0f;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsFloat");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setFloat("floatValue", floatValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a float  ");
            try {
                boolean b = messageReceived.getBoolean("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a float");
            try {
                if (messageReceived.getString("floatValue").equals(Float.toString(floatValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read  a float ");
            try {
                byte[] b = messageReceived.getBytes("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a float  ");
            try {
                byte b = messageReceived.getByte("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a float");
            try {
                short s = messageReceived.getShort("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a long  ");
            try {
                char c = messageReceived.getChar("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a float");
            try {
                int i = messageReceived.getInt("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a long");
            try {
                long l = messageReceived.getLong("floatValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a float  ");
            try {
                if (messageReceived.getFloat("floatValue") == floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to float - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a float  ");
            try {
                if (messageReceived.getDouble("floatValue") == (double)floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to double - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsFloat", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsDouble() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            double doubleValue = 3.0;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsDouble");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setDouble("doubleValue", doubleValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a double  ");
            try {
                boolean b = messageReceived.getBoolean("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a double");
            try {
                if (messageReceived.getString("doubleValue").equals(Double.toString(doubleValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to string");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read  a double ");
            try {
                byte[] b = messageReceived.getBytes("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a double  ");
            try {
                byte b = messageReceived.getByte("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a double");
            try {
                short s = messageReceived.getShort("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a double  ");
            try {
                char c = messageReceived.getChar("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a double");
            try {
                int i = messageReceived.getInt("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a double");
            try {
                long l = messageReceived.getLong("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a double  ");
            try {
                float f = messageReceived.getFloat("doubleValue");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read an float  ");
            try {
                if (messageReceived.getDouble("doubleValue") == doubleValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to double ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsDouble", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsString() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean pass = true;
            String myString = "10";
            String myString2 = "true";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            messageSent.setString("myString2", myString2);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a String");
            try {
                if (messageReceived.getString("myString").equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: string to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read a String");
            try {
                byte[] b = messageReceived.getBytes("myString");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a String");
            try {
                if (messageReceived.getByte("myString") == Byte.parseByte(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to byte ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a string");
            try {
                if (messageReceived.getShort("myString") == Short.parseShort(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to short ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a String ");
            try {
                char c = messageReceived.getChar("myString");
                logger.log(System.Logger.Level.TRACE, "getChar returned " + c);
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a String");
            try {
                if (messageReceived.getInt("myString") == Integer.parseInt(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to int ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a String");
            try {
                if (messageReceived.getLong("myString") == Long.parseLong(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to long ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a String");
            try {
                if (messageReceived.getFloat("myString") == Float.parseFloat(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to float ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a String");
            try {
                if (messageReceived.getDouble("myString") == Double.parseDouble(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to double ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a string ");
            try {
                if (messageReceived.getBoolean("myString2") == Boolean.valueOf(myString2).booleanValue()) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to boolean ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a string that is not true");
            try {
                boolean b = messageReceived.getBoolean("myString");
                if (b) {
                    logger.log(System.Logger.Level.INFO, "Fail: !true should have returned false");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: !true returned false");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsString", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsBytes() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            byte[] byteValues = new byte[]{1, 2, 3};
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsBytes");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setBytes("byteValues", byteValues);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBytes[] to read a byte[] ");
            try {
                byte[] b = messageReceived.getBytes("byteValues");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != byteValues[i]) {
                        logger.log(System.Logger.Level.INFO, "Fail: byte[] value returned is invalid");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Pass: byte[] returned is valid");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getBoolean to read a byte[]");
            try {
                boolean b = messageReceived.getBoolean("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getString to read a byte[]");
            try {
                String s = messageReceived.getString("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a byte[] - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a byte[] - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getChar to read a byte[] - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a byte[] - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a byte[] - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a byte[] - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a byte[] - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("byteValues");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsBytes", e);
        }
    }

    @Test
    public void MapMessageConversionQTestsInvFormatString() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean pass = true;
            String myString = "mytest string";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsInvFormatString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Msg recvd: " + messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME"));
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getByte to read a String that is not valid ");
            try {
                byte b = messageReceived.getByte("myString");
                logger.log(System.Logger.Level.INFO, "Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getShort to read a string that is not valid ");
            try {
                short s = messageReceived.getShort("myString");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getInt to read a String that is not valid ");
            try {
                int i = messageReceived.getInt("myString");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getLong to read a String that is not valid ");
            try {
                long l = messageReceived.getLong("myString");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getFloat to read a String that is not valid ");
            try {
                float f = messageReceived.getFloat("myString");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use getDouble to read a String that is not valid ");
            try {
                double d = messageReceived.getDouble("myString");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionQTestsInvFormatString", e);
        }
    }

    @Test
    public void mapMessageQNotWritable() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            char cValue = '\uffff';
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            byte[] bbValue = new byte[]{0, 88, 127};
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageQNotWritable");
            try {
                messageSent.setString("ssValue", ssValue);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception was thrown: ", (Throwable)e);
                throw new Exception("Error: failed to setString", e);
            }
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Writing a boolean ... ");
            try {
                messageReceived.setBoolean("pass", pass);
                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                throw new Exception("Error: test failed to be able to setBoolean");
            }
            catch (MessageNotWriteableException e) {
                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setBoolean");
                logger.log(System.Logger.Level.INFO, "Writing a byte ... ");
                try {
                    messageReceived.setByte("bValue", bValue);
                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                    throw new Exception("Error: test failed to be able to setByte");
                }
                catch (MessageNotWriteableException e2) {
                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setByte");
                    logger.log(System.Logger.Level.INFO, "Writing a short ... ");
                    try {
                        messageReceived.setShort("sValue", sValue);
                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                        throw new Exception("Error: test failed to be able to setShort");
                    }
                    catch (MessageNotWriteableException e3) {
                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setShort");
                        logger.log(System.Logger.Level.INFO, "Writing a char ... ");
                        try {
                            messageReceived.setChar("cValue", cValue);
                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                            throw new Exception("Error: test failed to be able to setChar");
                        }
                        catch (MessageNotWriteableException e4) {
                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setChar");
                            logger.log(System.Logger.Level.INFO, "Writing a int ... ");
                            try {
                                messageReceived.setInt("iValue", iValue);
                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                throw new Exception("Error: test failed to be able to setInt");
                            }
                            catch (MessageNotWriteableException e5) {
                                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setInt");
                                logger.log(System.Logger.Level.INFO, "Writing a long ... ");
                                try {
                                    messageReceived.setLong("lValue", lValue);
                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to setLong");
                                }
                                catch (MessageNotWriteableException e6) {
                                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setLong");
                                    logger.log(System.Logger.Level.INFO, "Writing a float ... ");
                                    try {
                                        messageReceived.setFloat("fValue", fValue);
                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to setFloat");
                                    }
                                    catch (MessageNotWriteableException e7) {
                                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setFloat");
                                        logger.log(System.Logger.Level.INFO, "Writing a double ... ");
                                        try {
                                            messageReceived.setDouble("dValue", dValue);
                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to setDouble");
                                        }
                                        catch (MessageNotWriteableException e8) {
                                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setDouble");
                                            logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                            try {
                                                messageReceived.setBytes("bbValue", bbValue);
                                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to setBytes");
                                            }
                                            catch (MessageNotWriteableException e9) {
                                                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setBytes");
                                                logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                                try {
                                                    messageReceived.setBytes("bbValue", bbValue, 0, 1);
                                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                    throw new Exception("Error: test failed to be able to setBytes");
                                                }
                                                catch (MessageNotWriteableException e10) {
                                                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setBytes");
                                                    logger.log(System.Logger.Level.INFO, "Writing a string ... ");
                                                    try {
                                                        messageReceived.setString("ssValue", ssValue);
                                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                        throw new Exception("Error: test failed to be able to setString");
                                                    }
                                                    catch (MessageNotWriteableException e11) {
                                                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setString");
                                                        logger.log(System.Logger.Level.INFO, "Writing a object ... ");
                                                        try {
                                                            messageReceived.setObject("oValue", (Object)new Integer(iValue));
                                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                            throw new Exception("Error: test failed to be able to setObject");
                                                        }
                                                        catch (MessageNotWriteableException e12) {
                                                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with setObject");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("mapMessageQNotWritable", e);
        }
    }

    @Test
    public void mapMessageQIllegalarg() throws Exception {
        try {
            MapMessage messageSent = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            char cValue = '\uffff';
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            byte[] bbValue = new byte[]{0, 88, 127};
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageQIllegalarg");
            logger.log(System.Logger.Level.INFO, "Writing a boolean ... ");
            try {
                messageSent.setBoolean("", pass);
                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                throw new Exception("Error: test failed to be able to setBoolean");
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setBoolean");
                logger.log(System.Logger.Level.INFO, "Writing a byte ... ");
                try {
                    messageSent.setByte("", bValue);
                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                    throw new Exception("Error: test failed to be able to setByte");
                }
                catch (IllegalArgumentException e2) {
                    logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setByte");
                    logger.log(System.Logger.Level.INFO, "Writing a short ... ");
                    try {
                        messageSent.setShort("", sValue);
                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                        throw new Exception("Error: test failed to be able to setShort");
                    }
                    catch (IllegalArgumentException e3) {
                        logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setShort");
                        logger.log(System.Logger.Level.INFO, "Writing a char ... ");
                        try {
                            messageSent.setChar("", cValue);
                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                            throw new Exception("Error: test failed to be able to setChar");
                        }
                        catch (IllegalArgumentException e4) {
                            logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setChar");
                            logger.log(System.Logger.Level.INFO, "Writing a int ... ");
                            try {
                                messageSent.setInt("", iValue);
                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                throw new Exception("Error: test failed to be able to setInt");
                            }
                            catch (IllegalArgumentException e5) {
                                logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setInt");
                                logger.log(System.Logger.Level.INFO, "Writing a long ... ");
                                try {
                                    messageSent.setLong("", lValue);
                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to setLong");
                                }
                                catch (IllegalArgumentException e6) {
                                    logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setLong");
                                    logger.log(System.Logger.Level.INFO, "Writing a float ... ");
                                    try {
                                        messageSent.setFloat("", fValue);
                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to setFloat");
                                    }
                                    catch (IllegalArgumentException e7) {
                                        logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setFloat");
                                        logger.log(System.Logger.Level.INFO, "Writing a double ... ");
                                        try {
                                            messageSent.setDouble("", dValue);
                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to setDouble");
                                        }
                                        catch (IllegalArgumentException e8) {
                                            logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setDouble");
                                            logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                            try {
                                                messageSent.setBytes("", bbValue);
                                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to setBytes");
                                            }
                                            catch (IllegalArgumentException e9) {
                                                logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setBytes");
                                                logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                                try {
                                                    messageSent.setBytes("", bbValue, 0, 1);
                                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                    throw new Exception("Error: test failed to be able to setBytes");
                                                }
                                                catch (IllegalArgumentException e10) {
                                                    logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setBytes");
                                                    logger.log(System.Logger.Level.INFO, "Writing a string ... ");
                                                    try {
                                                        messageSent.setString("", ssValue);
                                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                        throw new Exception("Error: test failed to be able to setString");
                                                    }
                                                    catch (IllegalArgumentException e11) {
                                                        logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setString");
                                                        logger.log(System.Logger.Level.INFO, "Writing a object ... ");
                                                        try {
                                                            messageSent.setObject("", (Object)new Integer(iValue));
                                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                            throw new Exception("Error: test failed to be able to setObject");
                                                        }
                                                        catch (IllegalArgumentException e12) {
                                                            logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setObject");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("mapMessageQIllegalarg", e);
        }
    }
}

