/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.exceptionQueue;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExceptionQueueTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.exceptionQueue.ExceptionQueueTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ExceptionQueueTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void xInvalidDestinationExceptionQTest() throws Exception {
        boolean pass = true;
        QueueBrowser qBrowser = null;
        QueueSender qSender = null;
        QueueReceiver qReceiver = null;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "** Close default QueueReceiver **");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Test createBrowser(null)");
            Queue dummy = null;
            try {
                qBrowser = this.tool.getDefaultQueueSession().createBrowser(dummy);
                if (qBrowser != null) {
                    logger.log(System.Logger.Level.TRACE, "qBrowser=" + qBrowser);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createBrowser(null),selector");
            try {
                qBrowser = this.tool.getDefaultQueueSession().createBrowser(dummy, "TEST");
                if (qBrowser != null) {
                    logger.log(System.Logger.Level.TRACE, "qBrowser=" + qBrowser);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createReceiver(null)");
            try {
                qReceiver = this.tool.getDefaultQueueSession().createReceiver(dummy);
                if (qReceiver != null) {
                    logger.log(System.Logger.Level.TRACE, "qReceiver=" + qReceiver);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createReceiver(null,selector)");
            try {
                qReceiver = this.tool.getDefaultQueueSession().createReceiver(dummy, "TEST");
                if (qReceiver != null) {
                    logger.log(System.Logger.Level.TRACE, "qReceiver=" + qReceiver);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createSender(null) - null is valid here ");
            try {
                qSender = this.tool.getDefaultQueueSession().createSender(dummy);
                if (qSender != null) {
                    logger.log(System.Logger.Level.TRACE, "qSender=" + qSender);
                }
                logger.log(System.Logger.Level.TRACE, "PASS: ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during xInvalidDestinationExceptionQTest tests");
            }
        }
        catch (Exception e) {
            throw new Exception("xInvalidDestinationExceptionQTest", e);
        }
    }

    @Test
    public void xMessageNotReadableExceptionQueueTest() throws Exception {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            msg = this.tool.getDefaultQueueSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionQueueTest");
            try {
                msg.readByte();
                logger.log(System.Logger.Level.TRACE, "FAIL --- should not have gotten this far!");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageNotReadableException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + nr.getMessage());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            logger.log(System.Logger.Level.TRACE, "Expected MessageNotReadableException did not occur!");
            throw new Exception("xMessageNotReadableExceptionQueueTest test failed", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionQTestforTextMessage() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforTextMessage");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.setText("testing...");
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageNotWriteableException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + nr.getMessage());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforTextMessage");
        }
    }

    @Test
    public void xMessageNotWriteableExceptionQTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforBytesMessage");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.writeByte(bValue);
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageNotWriteableException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + nr.getMessage());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforBytesMessage", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionQTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforStreamMessage");
            messageSent.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.writeString("Testing...");
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageNotWriteableException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + nr.getMessage());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforStreamMessage", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionQTestforMapMessage() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforMapMessage");
            messageSent.setString("aString", "value");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.setString("aString", "value");
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageNotWriteableException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + nr.getMessage());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforMapMessage", e);
        }
    }

    @Test
    public void xNullPointerExceptionQueueTest() throws Exception {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            msg = this.tool.getDefaultQueueSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xNullPointerExceptionQueueTest");
            msg.writeBytes(null);
        }
        catch (NullPointerException nullp) {
            logger.log(System.Logger.Level.TRACE, "Passed.\n");
            logger.log(System.Logger.Level.TRACE, "NullPointerException occurred!");
            logger.log(System.Logger.Level.TRACE, " " + nullp.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            logger.log(System.Logger.Level.TRACE, "Expected NullPointerException did not occur!");
            throw new Exception("xNullPointerExceptionQueueTest");
        }
    }

    @Test
    public void xMessageEOFExceptionQTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionQTestforBytesMessage");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageEOFException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + end.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageEOFExceptionQTestforBytesMessage", e);
        }
    }

    @Test
    public void xMessageEOFExceptionQTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionQTestforStreamMessage");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageEOFException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + end.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageEOFExceptionQTestforStreamMessage", e);
        }
    }

    @Test
    public void xMessageFormatExceptionQTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            Object messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionQTestforBytesMessage");
            logger.log(System.Logger.Level.TRACE, "try to write an invalid object");
            try {
                messageSent.writeObject((Object)this.tool.getDefaultQueueSession());
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageFormatException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + fe.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageFormatExceptionQTestforBytesMessage", e);
        }
    }

    @Test
    public void xMessageFormatExceptionQTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte[] bValues = new byte[]{127, 0, 3};
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.writeBytes(bValues);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionQTestforStreamMessage");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageFormatException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                logger.log(System.Logger.Level.INFO, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageFormatException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + fe.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageFormatExceptionQTestforStreamMessage", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void xInvalidSelectorExceptionQueueTest() throws Exception {
        try {
            QueueBrowser qBrowser = null;
            QueueReceiver qReceiver = null;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "** Close default QueueReceiver **");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send message to Queue. Text = \"message 1\"");
            TextMessage msg1 = this.tool.getDefaultQueueSession().createTextMessage();
            msg1.setText("message 1");
            msg1.setStringProperty("COM_SUN_JMS_TESTNAME", "xInvalidSelectorExceptionQueueTest");
            this.tool.getDefaultQueueSender().send((Message)msg1);
            try {
                logger.log(System.Logger.Level.TRACE, "call createBrowser with incorrect selector.");
                qBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "=TEST 'test'");
                logger.log(System.Logger.Level.ERROR, "Error --- createBrowser didn't throw expected InvalidSelectorException!");
                pass = false;
            }
            catch (InvalidSelectorException es) {
                logger.log(System.Logger.Level.TRACE, "createBrowser threw expected InvalidSelectorException!");
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error -- Incorrect Exception thrown by createBrowser.", (Throwable)e);
            }
            finally {
                if (qBrowser != null) {
                    try {
                        qBrowser.close();
                    }
                    catch (Exception ee) {
                        logger.log(System.Logger.Level.ERROR, "Error -- failed to close qBrowser.", (Throwable)ee);
                    }
                }
            }
            try {
                logger.log(System.Logger.Level.TRACE, "call createReceiver with incorrect selector.");
                qReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "=TEST 'test'");
                if (qReceiver != null) {
                    logger.log(System.Logger.Level.TRACE, "qReceiver=" + qReceiver);
                }
                logger.log(System.Logger.Level.ERROR, "Error --- createReceiver didn't throw expected InvalidSelectorException!");
                pass = false;
            }
            catch (InvalidSelectorException es) {
                logger.log(System.Logger.Level.INFO, "createReceiver threw expected InvalidSelectorException!");
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error -- Incorrect Exception thrown by createReceiver.", (Throwable)e);
            }
            finally {
                if (qReceiver != null) {
                    try {
                        qReceiver.close();
                    }
                    catch (Exception ee) {
                        logger.log(System.Logger.Level.ERROR, "Error -- failed to close qReceiver.", (Throwable)ee);
                    }
                }
            }
            if (!pass) {
                throw new Exception("xInvalidSelectorExceptionQueueTest failed!!");
            }
        }
        catch (Exception e) {
            throw new Exception("xInvalidSelectorExceptionQueueTest: ", e);
        }
    }

    @Test
    public void xIllegalStateExceptionQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Calling session.commit(), an illegal operation.");
            try {
                this.tool.getDefaultQueueSession().commit();
            }
            catch (IllegalStateException iStateE) {
                passed = true;
                logger.log(System.Logger.Level.INFO, "Received jakarta.jms.IllegalStateException -- GOOD");
                logger.log(System.Logger.Level.TRACE, "Exception message: " + iStateE.getMessage());
            }
            if (!passed) {
                throw new Exception("Did not receive IllegalStateException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionQueueTest");
        }
    }

    @Test
    public void xUnsupportedOperationExceptionQTest1() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Queue myQueue = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueSender().close();
            qSender = this.tool.getDefaultQueueSession().createSender(myQueue);
            this.tool.getDefaultQueueConnection().start();
            try {
                messageSent = this.tool.getDefaultQueueSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest1");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                qSender.send((Message)messageSent);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSender.send(Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from QueueSender.send(Message)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSender.send(Message) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                messageSent = this.tool.getDefaultQueueSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest1");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                qSender.send((Message)messageSent, 2, 4, 0L);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSender.send(Message, int, int, long) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from QueueSender.send(Message, int, int, long)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSender.send(Message, int, int, long) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionQTest1 Failed!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xUnsupportedOperationExceptionQTest1 Failed!", (Throwable)e);
            throw new Exception("xUnsupportedOperationExceptionQTest1 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultQueueConnection() != null) {
                    this.tool.flushQueue();
                    this.tool.getDefaultQueueConnection().close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception closing QueueConnection and cleanup", (Throwable)e);
            }
        }
    }

    @Test
    public void xUnsupportedOperationExceptionQTest2() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Destination myDest = null;
            MessageProducer mSender = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            mSender = this.tool.getDefaultSession().createProducer(myDest);
            this.tool.getDefaultConnection().start();
            try {
                messageSent = this.tool.getDefaultSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest2");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                mSender.send((Message)messageSent);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: MessageProducer.send(Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from MessageProducer.send(Message)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: MessageProducer.send(Message) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                messageSent = this.tool.getDefaultSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest2");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                mSender.send((Message)messageSent, 2, 4, 0L);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: MessageProducer.send(Message, int, int, long) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from MessageProducer.send(Message, int, int, long)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: MessageProducer.send(Message, int, int, long) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionQTest2 Failed!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xUnsupportedOperationExceptionQTest2 Failed!", (Throwable)e);
            throw new Exception("xUnsupportedOperationExceptionQTest2 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultConnection() != null) {
                    this.tool.flushDestination();
                    this.tool.getDefaultConnection().close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception closing Connection and cleanup", (Throwable)e);
            }
        }
    }

    @Test
    public void xUnsupportedOperationExceptionQTest3() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Destination myDest = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            try {
                messageSent = this.tool.getDefaultSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest3");
                logger.log(System.Logger.Level.TRACE, "get the second Destination");
                myDest = this.tool.getQueueDestination("MY_QUEUE2");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                this.tool.getDefaultProducer().send(myDest, (Message)messageSent);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: MessageProducer.send(Destination, Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from MessageProducer.send(Destination, Message)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: MessageProducer.send(Destination, Message) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionQTest3 Failed!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xUnsupportedOperationExceptionQTest3 Failed!", (Throwable)e);
            throw new Exception("xUnsupportedOperationExceptionQTest3 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultConnection() != null) {
                    this.tool.flushDestination();
                    this.tool.getDefaultConnection().close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception closing Connection and cleanup", (Throwable)e);
            }
        }
    }

    @Test
    public void xInvalidDestinationExceptionQTests() throws Exception {
        try {
            boolean pass = true;
            Destination dummy = null;
            Queue dummyQ = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, true) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ);
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createBrowser(null)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ, "TEST = 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createBrowser(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing the default Connection", (Throwable)ex);
            }
            if (!pass) {
                throw new Exception("xInvalidDestinationExceptionQTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xInvalidDestinationExceptionQTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xMessageNotReadableExceptionQBytesMsgTest() throws Exception {
        try {
            BytesMessage messageSent = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionQBytesMsgTest");
            logger.log(System.Logger.Level.INFO, "Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            try {
                messageSent.getBodyLength();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: getBodyLength didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "getBodyLength threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "getBodyLength threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBoolean();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readByte();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedByte();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readUnsignedByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readUnsignedByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readUnsignedByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readShort();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedShort();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readUnsignedShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readUnsignedShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readUnsignedShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readChar();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readInt();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readLong();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readFloat();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readDouble();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUTF();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readUTF didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readUTF threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readUTF threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd, 1);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBytes(byte[], int) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBytes(byte[], int) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBytes(byte[],int) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xMessageNotReadableExceptionQBytesMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotReadableExceptionQBytesMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xMessageNotReadableExceptionQStreamMsgTest() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionQStreamMsgTest");
            logger.log(System.Logger.Level.TRACE, "");
            logger.log(System.Logger.Level.INFO, "Writing one of each primitive type to the message");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "call ClearBody()");
            messageReceived.clearBody();
            try {
                messageReceived.readBoolean();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readByte();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readShort();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readChar();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readInt();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readLong();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readFloat();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readDouble();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readString();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readString didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readString threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readString threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readBytes(bValuesReturned);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readObject();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readObject didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readObject threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readObject threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xMessageNotReadableExceptionQStreamMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotReadableExceptionQStreamMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xIllegalStateExceptionTestTopicMethodsQ() throws Exception {
        try {
            boolean pass = true;
            Topic myTopic = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            myTopic = this.tool.createNewTopic("MY_TOPIC");
            try {
                this.tool.getDefaultQueueSession().createDurableSubscriber(myTopic, "cts");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createDurableSubscriber(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createDurableSubscriber(Topic, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createDurableSubscriber(Topic, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().createDurableSubscriber(myTopic, "cts", "TEST = 'test'", false);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createDurableSubscriber(Topic, String, String, boolean) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().createTemporaryTopic();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createTemporayTopic() didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createTemporayTopic()");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createTemporayTopic() throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().createTopic("foo");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createTopic(String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createTopic(String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.createTopic(String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().unsubscribe("foo");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.unsubscribe(String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.unsubscribe(String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.unsubscribe(String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xIllegalStateExceptionTestTopicMethodsQ Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionTestTopicMethodsQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xIllegalStateExceptionTestRollbackQ() throws Exception {
        try {
            TextMessage messageSent = null;
            Object messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xIllegalStateExceptionTestRollbackQ");
            logger.log(System.Logger.Level.TRACE, "Sending message to a Queue");
            this.tool.getDefaultProducer().send((Message)messageSent);
            try {
                logger.log(System.Logger.Level.TRACE, "Rolling back a non-transacted session must throw IllegalStateException");
                this.tool.getDefaultSession().rollback();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.rollback() didn't throw expected IllegalStateException");
            }
            catch (IllegalStateException en) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.rollback()");
            }
            if (!pass) {
                throw new Exception("xIllegalStateExceptionTestRollbackQ");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionTestRollbackQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }
}

