/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicSession;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedTopicSessionTestsIT {
    private static final String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
    private static final String testName = "com.sun.ts.tests.jms.core.closedTopicSession.ClosedTopicSessionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedTopicSessionTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    private void createAndCloseSession(int type) throws Exception {
        if (type == 1 || type == 3) {
            this.tool = new JmsTool(type, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Closing topic session");
            this.tool.getDefaultTopicSession().close();
        }
        logger.log(System.Logger.Level.INFO, "Session closed");
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedTopicSessionCommitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(3);
            logger.log(System.Logger.Level.INFO, "Try to call commit with closed session.");
            try {
                this.tool.getDefaultTopicSession().commit();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCommitTest");
        }
    }

    @Test
    public void closedTopicSessionCloseTest() throws Exception {
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to call close on closed session.");
            this.tool.getDefaultTopicSession().close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCloseTest");
        }
    }

    @Test
    public void closedTopicSessionCreateDurableSubscriberTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create DurableSubscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "TestDurableSubscriber");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateDurableSubscriberTest");
        }
    }

    @Test
    public void closedTopicSessionCreateDurableSubscriberMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create DurableSubscriber with message selector using closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "TestDurableSubscriberMsgSelector", "TEST = 'test'", false);
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateDurableSubscriberMsgSelectorTest");
        }
    }

    @Test
    public void closedTopicSessionCreateTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create topic with closed session.");
            try {
                Topic topic = this.tool.getDefaultTopicSession().createTopic("closedTopicSessionCreateTopicTest");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateTopicTest");
        }
    }

    @Test
    public void closedTopicSessionCreateSubscriberTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create Subscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateSubscriberTest");
        }
    }

    @Test
    public void closedTopicSessionCreateSubscriberMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create Subscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "TEST = 'test'", false);
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateSubscriberMsgSelectorTest");
        }
    }

    @Test
    public void closedTopicSessionCreatePublisherTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create Publisher with closed session.");
            try {
                TopicPublisher topicPublisher = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreatePublisherTest");
        }
    }

    @Test
    public void closedTopicSessionCreateTempTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create TemporaryTopic with closed session.");
            try {
                TemporaryTopic temporaryTopic = this.tool.getDefaultTopicSession().createTemporaryTopic();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateTempTopicTest");
        }
    }

    @Test
    public void closedTopicSessionUnsubscribeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to call unsubscribe with closed session.");
            try {
                this.tool.getDefaultTopicSession().unsubscribe("TestDurableSubscription");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionUnsubscribeTest");
        }
    }

    @Test
    public void closedTopicSessionCreateMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create message with closed session.");
            try {
                Message message = this.tool.getDefaultTopicSession().createMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateMessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateBytesMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create BytesMessage with closed session.");
            try {
                BytesMessage bytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateBytesMessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateMapMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create MapMessage with closed session.");
            try {
                MapMessage mapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateMapMessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateObjectMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create ObjectMessage with closed session.");
            try {
                ObjectMessage objectMessage = this.tool.getDefaultTopicSession().createObjectMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateObjectMessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateObject2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create ObjectMessage(object) with closed session.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    logger.log(System.Logger.Level.INFO, "ObjectMessage=" + m);
                }
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateObject2MessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateStreamMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create StreamMessage with closed session.");
            try {
                StreamMessage streamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateStreamMessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateTextMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultTopicSession().createTextMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateTextMessageTest");
        }
    }

    @Test
    public void closedTopicSessionCreateText2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultTopicSession().createTextMessage("test message");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateText2MessageTest");
        }
    }

    @Test
    public void closedTopicSessionGetTransactedTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to call getTransacted() with closed session.");
            try {
                boolean bl = this.tool.getDefaultTopicSession().getTransacted();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionGetTransactedTest");
        }
    }

    @Test
    public void closedTopicSessionRollbackTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to call rollback() with closed session.");
            try {
                this.tool.getDefaultTopicSession().rollback();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionRollbackTest");
        }
    }

    @Test
    public void closedTopicSessionRecoverTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.INFO, "Try to call recover() with closed session.");
            try {
                this.tool.getDefaultTopicSession().recover();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionRecoverTest");
        }
    }

    @Test
    public void closedTopicSessionSubscriberCloseTest() throws Exception {
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSubscriberCloseTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetMessageSelectorTest", e);
        }
    }

    @Test
    public void closedTopicSessionReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionReceiveTest", e);
        }
    }

    @Test
    public void closedTopicSessionReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionReceiveTimeoutTest", e);
        }
    }

    @Test
    public void closedTopicSessionReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionReceiveNoWaitTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetNoLocalTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetNoLocalTest", e);
        }
    }

    @Test
    public void closedTopicSessionSubscriberGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSubscriberGetTopicTest", e);
        }
    }

    @Test
    public void closedTopicSessionPublisherCloseTest() throws Exception {
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicPublisher().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublisherCloseTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getDeliveryMode();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageTimestamp();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getPriority");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getPriority();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetPriorityTest", e);
        }
    }

    @Test
    public void closedTopicSessionGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultTopicPublisher().getTimeToLive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedTopicSessionSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call setDeliveryMode");
            try {
                this.tool.getDefaultTopicPublisher().setDeliveryMode(2);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedTopicSessionSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageID");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageID(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedTopicSessionSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageTimestamp(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedTopicSessionSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call setPriority");
            try {
                this.tool.getDefaultTopicPublisher().setPriority(4);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetPriorityTest", e);
        }
    }

    @Test
    public void closedTopicSessionSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call setTimeToLive");
            try {
                this.tool.getDefaultTopicPublisher().setTimeToLive(0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedTopicSessionPublisherGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicPublisher().getTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublisherGetTopicTest", e);
        }
    }

    @Test
    public void closedTopicSessionPublish1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call publish(Message)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublish1Test", e);
        }
    }

    @Test
    public void closedTopicSessionPublish2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            logger.log(System.Logger.Level.TRACE, "Try to call publish(Message,int,int,long)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublish2Test", e);
        }
    }
}

