/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.queuetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.DoneLatch;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.SerialTestMessageListenerImpl;
import com.sun.ts.tests.jms.common.SessionThread;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import jakarta.jms.TopicConnection;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.queuetests.QueueTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(QueueTestsIT.class.getName());
    private transient JmsTool tool = null;
    ArrayList queues = null;
    ArrayList connections = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(10);
            this.connections = new ArrayList(5);
            logger.log(System.Logger.Level.INFO, "adding the default queue to the queue cleaner lsit\n");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void receiveNullClosedSessionQueueTest() throws Exception {
        int waitTime = 15;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Close default QueueReceiver");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Create QueueRequestor");
            QueueRequestor qReq = new QueueRequestor(this.tool.getDefaultQueueSession(), this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "Create SessionThread");
            SessionThread sT = new SessionThread(this.tool.getDefaultQueueConnection(), (TopicConnection)null);
            logger.log(System.Logger.Level.INFO, "Tell SessionThread to respond to messages");
            sT.setReplyToMessages(true);
            logger.log(System.Logger.Level.INFO, "Create Receiver in SessionThread");
            sT.createConsumer((Destination)this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "Tell receiver to keep receiving\n(it will throw an exception and stop when it receives the null message)");
            sT.setStayAlive(true);
            logger.log(System.Logger.Level.INFO, "Start the SessionThread");
            sT.start();
            logger.log(System.Logger.Level.INFO, "Send one message and receive reply");
            Message tempMsg = this.tool.getDefaultQueueSession().createMessage();
            tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "receiveNullClosedSessionQueueTest");
            qReq.request(tempMsg);
            logger.log(System.Logger.Level.INFO, "Wait " + waitTime + " seconds for receive() to start again before closing session...");
            for (int i = 0; i < 100000; ++i) {
            }
            logger.log(System.Logger.Level.INFO, "Close the SessionThread's QueueSession");
            sT.getQueueSession().close();
            logger.log(System.Logger.Level.INFO, "Wait for thread to close (will close after receiving null message)");
            sT.join();
            if (sT.isAlive()) {
                logger.log(System.Logger.Level.ERROR, "thread still waiting on receive() -- BAD [could be timing problem]");
                throw new Exception("receive() call still waiting");
            }
            logger.log(System.Logger.Level.INFO, "receive() properly received a null message -- GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("receiveNullClosedSessionQueueTest");
        }
    }

    @Test
    public void setClientIDLateQueueTest() throws Exception {
        boolean booleanValue = true;
        boolean pass = true;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            QueueConnection qConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(qConn);
            QueueSession qSess = qConn.createQueueSession(false, 1);
            Queue queue = this.tool.createNewQueue("testQueue2");
            this.queues.add(queue);
            QueueSender qSender = qSess.createSender(queue);
            QueueReceiver qRec = qSess.createReceiver(queue);
            qConn.start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            MapMessage messageSent = qSess.createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateQueueTest");
            messageSent.setBoolean("booleanValue", booleanValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            qSender.send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            MapMessage messageReceived = (MapMessage)qRec.receive(this.timeout);
            messageReceived.getBoolean("booleanValue");
            logger.log(System.Logger.Level.TRACE, "Attempt to set Client ID too late");
            try {
                qConn.setClientID("setClientIDLateQueueTest");
                pass = false;
                logger.log(System.Logger.Level.INFO, "Error: Illegal state exception was not thrown");
            }
            catch (IllegalStateException is) {
                logger.log(System.Logger.Level.TRACE, "Pass: IllegalStateException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setClientIDLateQueueTest");
        }
    }

    @Test
    public void autoAckMsgListenerQueueTest() throws Exception {
        try {
            Message messageSent = null;
            AutoAckMsgListener mListener = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Create and set MessageListener.");
            mListener = new AutoAckMsgListener(new DoneLatch(), this.tool.getDefaultQueueSession());
            this.tool.getDefaultQueueReceiver().setMessageListener((MessageListener)mListener);
            logger.log(System.Logger.Level.TRACE, "Send and receive two messages");
            messageSent = this.tool.getDefaultQueueSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "autoAckMsgListenerQueueTest");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(messageSent);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "waiting until message has been received by message listener...");
            mListener.monitor.waitTillDone();
            if (!mListener.getPassed()) {
                throw new Exception("failed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Error: " + e);
            throw new Exception("autoAckMsgListenerQueueTest", e);
        }
    }

    @Test
    public void serialMsgListenerQueueTest() throws Exception {
        try {
            TextMessage[] tMsg = new TextMessage[3];
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            Queue newQ = this.tool.createNewQueue("testQueue2");
            this.queues.add(newQ);
            QueueReceiver qRec1 = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            QueueReceiver qRec2 = this.tool.getDefaultQueueSession().createReceiver(newQ);
            logger.log(System.Logger.Level.INFO, "Create two message listeners");
            SerialTestMessageListenerImpl myListener1 = new SerialTestMessageListenerImpl();
            SerialTestMessageListenerImpl myListener2 = new SerialTestMessageListenerImpl();
            qRec1.setMessageListener((MessageListener)myListener1);
            qRec2.setMessageListener((MessageListener)myListener2);
            QueueSender qSender1 = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
            QueueSender qSender2 = this.tool.getDefaultQueueSession().createSender(newQ);
            for (int i = 0; i < 3; ++i) {
                logger.log(System.Logger.Level.INFO, "Create and send message " + i);
                tMsg[i] = this.tool.getDefaultQueueSession().createTextMessage();
                tMsg[i].setText("serialMsgListenerQueueTest" + i);
                tMsg[i].setStringProperty("COM_SUN_JMS_TESTNAME", "serialMsgListenerQueueTest" + i);
                if (i == 2) {
                    tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", true);
                    qSender1.send((Message)tMsg[i]);
                    qSender2.send((Message)tMsg[i]);
                    continue;
                }
                tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", false);
                if (i % 2 == 0) {
                    qSender1.send((Message)tMsg[i]);
                    continue;
                }
                qSender2.send((Message)tMsg[i]);
            }
            logger.log(System.Logger.Level.INFO, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            myListener1.monitor.waitTillDone();
            myListener2.monitor.waitTillDone();
            if (myListener1.testFailed || myListener2.testFailed) {
                logger.log(System.Logger.Level.INFO, "Test failed in message listener");
                throw new Exception("Concurrent use of MessageListener or JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("serialMsgListenerQueueTest");
        }
    }

    @Test
    public void setGetChangeClientIDQueueTest() throws Exception {
        boolean pass = true;
        QueueConnection qc2 = null;
        try {
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            QueueConnection qc = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(qc);
            qc2 = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(qc2);
            logger.log(System.Logger.Level.INFO, "Setting clientID!");
            qc.setClientID("ctstest");
            logger.log(System.Logger.Level.INFO, "Getting clientID!");
            String clientid = qc.getClientID();
            if (!clientid.equals("ctstest")) {
                logger.log(System.Logger.Level.ERROR, "getClientID() returned " + clientid + ", expected ctstest");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "setClientID/getClientID correct");
            }
            logger.log(System.Logger.Level.INFO, "Resetting clientID! (excpect IllegalStateException)");
            qc.setClientID("changeIt");
            logger.log(System.Logger.Level.ERROR, "Failed: No exception on ClientID reset");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + e.getMessage());
            pass = false;
        }
        catch (IllegalStateException ee) {
            logger.log(System.Logger.Level.INFO, "Expected Exception received: " + ee.getMessage());
        }
        catch (Exception eee) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + eee.getMessage());
            pass = false;
        }
        try {
            logger.log(System.Logger.Level.INFO, "Set clientID on second connection to value of clientID on first connection");
            logger.log(System.Logger.Level.INFO, "Expect InvalidClientIDException");
            qc2.setClientID("ctstest");
            logger.log(System.Logger.Level.ERROR, "Failed: No exception on ClientID when one already exists");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            logger.log(System.Logger.Level.INFO, "Expected exception received: " + e.getMessage());
        }
        catch (Exception eee) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + eee.getMessage());
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetChangeClientIDQueueTest");
        }
    }

    @Test
    public void setGetExceptionListenerTest() throws Exception {
        boolean pass = true;
        Object qc = null;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for QUEUE");
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Create ExceptionListener");
            ExceptionListener foo = new ExceptionListener(){

                public void onException(JMSException e) {
                }
            };
            logger.log(System.Logger.Level.INFO, "Call setExceptionListener on Connection object");
            this.tool.getDefaultQueueConnection().setExceptionListener(foo);
            ExceptionListener foo2 = this.tool.getDefaultQueueConnection().getExceptionListener();
            if (!foo2.equals(foo)) {
                logger.log(System.Logger.Level.ERROR, "getExceptionListener doesn't match setExceptionListener");
                pass = false;
            }
        }
        catch (Exception eee) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received: " + eee.getMessage());
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetExceptionListenerTest");
        }
    }

    @Test
    public void reverseReceiveClientAckTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            int i2;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            Queue[] q = new Queue[3];
            QueueSender[] qSender = new QueueSender[3];
            QueueReceiver[] qReceiver = new QueueReceiver[3];
            Message[] msg = new Message[3];
            for (i2 = 0; i2 < 3; ++i2) {
                logger.log(System.Logger.Level.INFO, "Creating Queue " + i2 + " of 2 (3 total)");
                q[i2] = this.tool.createNewQueue("testQ" + i2);
                this.queues.add(q[i2]);
            }
            logger.log(System.Logger.Level.INFO, "Creating 3 senders");
            for (i2 = 0; i2 < 3; ++i2) {
                logger.log(System.Logger.Level.INFO, "sender " + i2);
                qSender[i2] = this.tool.getDefaultQueueSession().createSender(q[i2]);
            }
            logger.log(System.Logger.Level.INFO, "Creating CLIENT_ACKNOWLEDGE session for receiving");
            QueueSession receiveSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            logger.log(System.Logger.Level.INFO, "Creating 3 receivers in receive session");
            for (int i3 = 0; i3 < 3; ++i3) {
                logger.log(System.Logger.Level.INFO, "receiver " + i3);
                qReceiver[i3] = receiveSession.createReceiver(q[i3]);
            }
            this.tool.getDefaultQueueConnection().start();
            Message tempMsg = null;
            for (i = 0; i < 3; ++i) {
                logger.log(System.Logger.Level.INFO, "Sending message " + i);
                tempMsg = this.tool.getDefaultQueueSession().createMessage();
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "reverseReceiveClientAckTest");
                qSender[i].send(tempMsg);
            }
            logger.log(System.Logger.Level.INFO, "Receive messages 0-2 in reverse order");
            for (i = 2; i >= 0; --i) {
                logger.log(System.Logger.Level.INFO, "Receive message " + i);
                msg[i] = qReceiver[i].receive(this.timeout);
                if (msg[i] == null) {
                    logger.log(System.Logger.Level.ERROR, "Did not receive message from receiver[" + i + "]");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "msg = " + msg[i]);
                    logger.log(System.Logger.Level.INFO, "Acknowledge message " + i);
                    msg[i].acknowledge();
                }
                if (i != 2) continue;
                logger.log(System.Logger.Level.INFO, "session.recover()");
                receiveSession.recover();
            }
            logger.log(System.Logger.Level.INFO, "Try receiving message from all receivers again (should not receive any)");
            for (i = 2; i >= 0; --i) {
                msg[i] = qReceiver[i].receive(this.timeout);
                if (msg[i] == null) continue;
                logger.log(System.Logger.Level.ERROR, "Received message from receiver[" + i + "], expected none");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("reverseReceiveClientAckTest");
        }
        finally {
            try {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning", (Throwable)e);
                throw new Exception("Cleanup failed!", e);
            }
        }
        if (!pass) {
            throw new Exception("reverseReceiveClientAckTest");
        }
    }

    @Test
    public void clientAckQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage sent1 = null;
            TextMessage sent2 = null;
            TextMessage sent3 = null;
            TextMessage sent4 = null;
            TextMessage rec2 = null;
            TextMessage rec4 = null;
            QueueSession qSess = null;
            QueueReceiver qRec = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            logger.log(System.Logger.Level.INFO, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            sent1 = qSess.createTextMessage();
            sent1.setText("test message 1");
            sent1.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest1");
            sent2 = qSess.createTextMessage();
            sent2.setText("test message 2");
            sent2.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest2");
            sent3 = qSess.createTextMessage();
            sent3.setText("test message 3");
            sent3.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest3");
            sent4 = qSess.createTextMessage();
            sent4.setText("test message 4");
            sent4.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest4");
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            qSender = qSess.createSender(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.TRACE, "Send three messages");
            qSender.send((Message)sent1);
            qSender.send((Message)sent2);
            qSender.send((Message)sent3);
            logger.log(System.Logger.Level.TRACE, "Receive three messages");
            qRec.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the first message");
            rec2 = (TextMessage)qRec.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the second message");
            qRec.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the third message");
            logger.log(System.Logger.Level.TRACE, "Acknowledging the second message");
            rec2.acknowledge();
            logger.log(System.Logger.Level.TRACE, "Send the fourth message");
            qSender.send((Message)sent4);
            logger.log(System.Logger.Level.TRACE, "Receive the fourth message");
            rec4 = (TextMessage)qRec.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the fourth message");
            logger.log(System.Logger.Level.TRACE, "Call session.recover()");
            qSess.recover();
            logger.log(System.Logger.Level.TRACE, "Attempt to receive unacked message - the fourth message again");
            rec4 = (TextMessage)qRec.receive(this.timeout);
            if (rec4 == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Did not receive unacked message");
            } else {
                if (!rec4.getText().equals(sent4.getText())) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Received wrong message: " + rec4.getText());
                } else {
                    logger.log(System.Logger.Level.INFO, "Re-received message: " + rec4.getText());
                }
                logger.log(System.Logger.Level.TRACE, "Acknowledge the received message");
                rec4.acknowledge();
            }
            if (!pass) {
                throw new Exception("clientAckQueueTest Failed!!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: ", (Throwable)e);
            throw new Exception("clientAckQueueTest", e);
        }
        finally {
            try {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning", (Throwable)e);
                throw new Exception("Cleanup failed!", e);
            }
        }
    }

    @Test
    public void nonAckMsgsRedeliveredQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg;
            int i;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Close QueueReceiver in default session -- only want one for Queue");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            QueueSession qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            QueueReceiver qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            QueueSender qSender = qSession.createSender(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            for (i = 0; i < 3; ++i) {
                tempMsg = qSession.createTextMessage();
                tempMsg.setText("test message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "nonAckMsgsRedeliveredQueueTest" + i);
                qSender.send((Message)tempMsg);
                logger.log(System.Logger.Level.TRACE, "sent message " + i);
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)qReceiver.receive(this.timeout);
                if (tempMsg == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Did not receive message " + i);
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "received message " + i);
            }
            qSender.close();
            qReceiver.close();
            qSession.close();
            qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)qReceiver.receive(this.timeout);
                if (tempMsg == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Did not receive message " + i);
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "received message \"" + tempMsg.getText() + "\" second time");
            }
            if (!pass) {
                throw new Exception("nonAckMsgsRedeliveredQueueTest failed!!!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "nonAckMsgsRedeliveredQueueTest failed: ", (Throwable)e);
            throw new Exception("nonAckMsgsRedeliveredQueueTest failed", e);
        }
        finally {
            try {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning", (Throwable)e);
                throw new Exception("Cleanup failed!", e);
            }
        }
    }

    @Test
    public void queueRequestorSimpleSendAndRecvTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueRequestor qreq = null;
            logger.log(System.Logger.Level.INFO, "Set up JmsTool for QUEUE");
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("This is the request message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "queueRequestorSimpleSendAndRecvTest");
            logger.log(System.Logger.Level.INFO, "Set up MessageListener");
            this.tool.getDefaultQueueReceiver().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultQueueSession()));
            logger.log(System.Logger.Level.INFO, "Set up QueueRequestor for request/response message exchange");
            QueueSession newqs = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qreq = new QueueRequestor(newqs, this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "Send message request and receive message response using QueueRequestor");
            logger.log(System.Logger.Level.INFO, "Message request text: \"" + messageSent.getText() + "\"");
            messageReceived = (TextMessage)qreq.request((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Message response text: \"" + messageReceived.getText() + "\"");
            if (messageReceived.getText().equals("This is the response message")) {
                logger.log(System.Logger.Level.INFO, "Received correct response message");
            } else {
                logger.log(System.Logger.Level.ERROR, "Received incorrect response message");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Close QueueRequestor");
            qreq.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueRequestorSimpleSendAndRecvTest failed");
        }
        if (!pass) {
            throw new Exception("queueRequestorSimpleSendAndRecvTest failed");
        }
    }

    @Test
    public void queueRequestorExceptionTests() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Queue invalidDest = null;
            QueueRequestor qreq = null;
            logger.log(System.Logger.Level.INFO, "Set up JmsTool for QUEUE");
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Set up MessageListener");
            this.tool.getDefaultQueueReceiver().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultQueueSession()));
            QueueSession newqs = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            try {
                logger.log(System.Logger.Level.INFO, "Set up QueueRequestor with InvalidDestination");
                qreq = new QueueRequestor(newqs, invalidDest);
                logger.log(System.Logger.Level.ERROR, "Didn't throw InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
            }
            try {
                logger.log(System.Logger.Level.INFO, "Set up QueueRequestor with a closed QueueSession");
                newqs.close();
                qreq = new QueueRequestor(newqs, this.tool.getDefaultQueue());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            this.tool.closeAllConnections(this.connections);
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Set up QueueRequestor");
            qreq = new QueueRequestor(this.tool.getDefaultQueueSession(), this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "queueRequestorExceptionTests");
            logger.log(System.Logger.Level.INFO, "Close QueueRequestor");
            qreq.close();
            logger.log(System.Logger.Level.INFO, "Try a request/response message exchange on a closed QueueRequestor");
            try {
                messageReceived = (TextMessage)qreq.request((Message)messageSent);
                if (messageReceived != null) {
                    logger.log(System.Logger.Level.INFO, "messageReceived=" + messageReceived.getText());
                }
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
                qreq.close();
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueRequestorExceptionTests failed");
        }
        if (!pass) {
            throw new Exception("queueRequestorExceptionTests failed");
        }
    }

    private static class AutoAckMsgListener
    implements MessageListener {
        private boolean passed;
        QueueSession session;
        final DoneLatch monitor;

        public AutoAckMsgListener(DoneLatch latch, QueueSession qSession) {
            this.monitor = latch;
            this.session = qSession;
        }

        public boolean getPassed() {
            return this.passed;
        }

        public void onMessage(Message message) {
            try {
                if (!message.getBooleanProperty("lastMessage")) {
                    logger.log(System.Logger.Level.TRACE, "Received first message.");
                    if (message.getJMSRedelivered()) {
                        logger.log(System.Logger.Level.INFO, "Error: received first message twice");
                        this.passed = false;
                    }
                } else if (!message.getJMSRedelivered()) {
                    logger.log(System.Logger.Level.TRACE, "Received second message. Calling recover()");
                    this.session.recover();
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received second message again as expected");
                    this.passed = true;
                    this.monitor.allDone();
                }
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Exception caught in message listener:\n" + e);
                this.passed = false;
                this.monitor.allDone();
            }
        }
    }

    private static class RequestorMsgListener
    implements MessageListener {
        QueueSession session = null;
        boolean pass = false;

        public RequestorMsgListener(QueueSession session) {
            this.session = session;
        }

        public boolean getPass() {
            return this.pass;
        }

        public void onMessage(Message message) {
            try {
                logger.log(System.Logger.Level.INFO, "RequestorMsgListener.onMessage()");
                if (message instanceof TextMessage) {
                    TextMessage tmsg = (TextMessage)message;
                    logger.log(System.Logger.Level.INFO, "Request message=" + tmsg.getText());
                    if (tmsg.getText().equals("This is the request message")) {
                        logger.log(System.Logger.Level.INFO, "Received request message is correct");
                        this.pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received request message is incorrect");
                        this.pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received request message is not a TextMessage");
                    this.pass = false;
                }
                Queue replyQ = (Queue)message.getJMSReplyTo();
                QueueSender sender = this.session.createSender(replyQ);
                TextMessage responseMsg = this.session.createTextMessage();
                responseMsg.setText("This is the response message");
                responseMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "RequestorMsgListenerResponseMsg");
                logger.log(System.Logger.Level.INFO, "Sending back response message");
                sender.send((Message)responseMsg);
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Exception caught in RequestorMsgListener:\n" + e);
            }
        }
    }
}

