/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedTopicConnection;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedTopicConnectionTestsIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedTopicConnection.ClosedTopicConnectionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final System.Logger logger = System.getLogger(ClosedTopicConnectionTestsIT.class.getName());
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    private void createAndCloseConnection(int type, String user, String password) throws Exception {
        if (type == 1 || type == 3) {
            tool = new JmsTool(type, user, password, this.mode);
            tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Closing queue Connection");
            tool.getDefaultTopicConnection().close();
        }
        logger.log(System.Logger.Level.TRACE, "Connection closed");
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            logger.log(System.Logger.Level.TRACE, "Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (tool != null) {
                logger.log(System.Logger.Level.TRACE, "Cleanup: Closing Topic and Topic Connections");
                tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedTopicConnectionGetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getExceptionListener");
            try {
                ExceptionListener foo = tool.getDefaultTopicConnection().getExceptionListener();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetExceptionListenerTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setClientID");
            try {
                tool.getDefaultTopicConnection().setClientID("foo");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetClientIDTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setExceptionListener");
            try {
                ExceptionListener foo = new ExceptionListener(){

                    public void onException(JMSException jmsE) {
                    }
                };
                tool.getDefaultTopicConnection().setExceptionListener(foo);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetExceptionListenerTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageListener");
            try {
                MessageListener foo = tool.getDefaultTopicSubscriber().getMessageListener();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetMessageListenerTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                tool.getDefaultTopicSubscriber().setMessageListener(foo);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetMessageListenerTest", e);
        }
    }

    @Test
    public void closedTopicConnectionStopTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call stop");
            try {
                tool.getDefaultTopicConnection().stop();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionStopTest", e);
        }
    }
}

