/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedQueueReceiver;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedQueueReceiverIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedQueueReceiver.ClosedQueueReceiverTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final System.Logger logger = System.getLogger(ClosedQueueReceiverIT.class.getName());
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    private void createAndCloseReceiver() throws Exception {
        tool = new JmsTool(0, this.user, this.password, this.mode);
        tool.getDefaultQueueConnection().start();
        logger.log(System.Logger.Level.TRACE, "Closing queue receiver");
        tool.getDefaultQueueReceiver().close();
        logger.log(System.Logger.Level.TRACE, "Receiver closed");
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(2);
            logger.log(System.Logger.Level.TRACE, "Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedQueueReceiverGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageListener");
            try {
                MessageListener foo = tool.getDefaultQueueReceiver().getMessageListener();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverGetMessageListenerTest", e);
        }
    }

    @Test
    public void closedQueueReceiverSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                tool.getDefaultQueueReceiver().setMessageListener(foo);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverSetMessageListenerTest", e);
        }
    }
}

