/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.listeners;

import com.sun.ts.tests.jstl.common.wrappers.TckDataSourceWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public final class SQLContextListener
implements ServletContextListener {
    private static final String IURL = "URL";
    private static final String IDRIVER = "driver";
    private static final String IUSER = "user";
    private static final String IPASSWORD = "password";
    private static final String JSTLDS = "jstlDS";
    private static final String LOGDS = "logDS";
    private static final String SQLPROPS = "sqlProps";
    private static final String PROPS_URI = "/WEB-INF/sql.properties";
    private static final String JSTL_TAB1_ROWS = "JSTL_TAB1_ROWS";
    private ServletContext _context = null;
    private boolean _debug = true;

    public void contextInitialized(ServletContextEvent event) {
        this._context = event.getServletContext();
        String url = this._context.getInitParameter(IURL);
        String driver = this._context.getInitParameter(IDRIVER);
        String user = this._context.getInitParameter(IUSER);
        String password = this._context.getInitParameter(IPASSWORD);
        Integer jstl_tab1_rows = new Integer(this._context.getInitParameter(JSTL_TAB1_ROWS));
        this._context.setAttribute(JSTL_TAB1_ROWS, (Object)jstl_tab1_rows);
        try {
            this.trace("Creating TckDataSourceWrapper...");
            TckDataSourceWrapper ds = new TckDataSourceWrapper();
            ds.setDriverClassName(driver);
            ds.setJdbcURL(url);
            ds.setUserName(user);
            ds.setPassword(password);
            this.trace("TckDataSourceWrapper, jstlDS, created: " + ds);
            this.trace("TckDataSourceWrapper info: " + ds.getDSInfo());
            this._context.setAttribute(JSTLDS, (Object)ds);
        }
        catch (Exception ex) {
            this.trace("Couldn't create DataSource Wrapper, jstlDS: " + ex.toString());
            this.trace("Exception message: " + ex.getMessage());
        }
        try {
            this.trace("Creating TckDataSourceWrapper that returns wrapped Connections...");
            TckDataSourceWrapper dsw = new TckDataSourceWrapper(this._context);
            dsw.setDriverClassName(driver);
            dsw.setJdbcURL(url);
            dsw.setUserName(user);
            dsw.setPassword(password);
            this.trace("TckDataSourceWrapper, logDS, created: " + dsw);
            this.trace("TckDataSourceWrapper info: " + dsw.getDSInfo());
            this._context.setAttribute(LOGDS, (Object)dsw);
        }
        catch (Exception ex) {
            this.trace("Couldn't create DataSource Wrapper, logDS: " + ex.toString());
            this.trace("Exception message: " + ex.getMessage());
        }
        Properties props = new Properties();
        this._context.setAttribute(SQLPROPS, (Object)props);
        try {
            this.trace("Loading sql.properties from URI: /WEB-INF/sql.properties");
            props.load(this._context.getResourceAsStream(PROPS_URI));
            if (this._debug) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.trace(key + "=" + props.getProperty(key));
                }
            }
        }
        catch (IOException io) {
            this.trace("Unexpected IOException loading sql.properties from URI: /WEB-INF/sql.properties");
            this.trace("Exception received: " + io.toString());
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this._context.removeAttribute(JSTLDS);
        this.trace("Removed jstlDS from context.");
        this._context.removeAttribute(LOGDS);
        this.trace("Removed logDS from context.");
        this._context.removeAttribute(SQLPROPS);
        this.trace("Removed sqlProps from context.");
        this._context.removeAttribute(JSTL_TAB1_ROWS);
        this.trace("Removed JSTL_TAB1_ROWS from context.");
    }

    private void trace(String buf) {
        if (this._debug) {
            this._context.log("[SQLContextListener] " + buf);
        }
    }

    static {
        IURL = IURL;
        IDRIVER = IDRIVER;
        IUSER = IUSER;
        IPASSWORD = IPASSWORD;
        JSTLDS = JSTLDS;
        LOGDS = LOGDS;
        SQLPROPS = SQLPROPS;
        PROPS_URI = PROPS_URI;
        JSTL_TAB1_ROWS = JSTL_TAB1_ROWS;
    }
}

