/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.mapattribute;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.mapattribute.Department;
import ee.jakarta.tck.persistence.core.metamodelapi.mapattribute.Employee;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getJavaKeyType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                Class javaKeyType = mapAttrib.getKeyJavaType();
                if (javaKeyType.getName().equals("java.lang.String")) {
                    this.logTrace("Received Expected Map Attribute's Java Key Type  = " + javaKeyType.getName());
                    pass = true;
                } else {
                    this.logTrace("Received UnExpected Map Attribute's Java Key Type  = " + javaKeyType.getName());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaKeyType Test  failed");
        }
    }

    public void getKeyType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                Type keyType = mapAttrib.getKeyType();
                String javaKeyTypeName = keyType.getJavaType().getName();
                if (javaKeyTypeName.equals("java.lang.String")) {
                    this.logTrace("Received Expected Map Attribute's Java Key Type  = " + javaKeyTypeName);
                    pass = true;
                } else {
                    this.logTrace("Received UnExpected Map Attribute's Java Key Type  = " + javaKeyTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getKeyType Test  failed");
        }
    }

    public void getCollectionType() throws Exception {
        boolean pass = false;
        String expected = PluralAttribute.CollectionType.MAP.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                PluralAttribute.CollectionType type = mapAttrib.getCollectionType();
                if (type != null) {
                    String name = type.name();
                    if (name.equals(expected)) {
                        this.logTrace("Received expected result: " + name);
                        pass = true;
                    } else {
                        this.logTrace("Expected: " + expected + ", actual: " + name);
                    }
                } else {
                    this.logErr("getCollectionType() returned null");
                }
            } else {
                this.logErr("managedType() returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    public void getElementType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.mapattribute.Employee";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                Type type = mapAttrib.getElementType();
                if (type != null) {
                    String name = type.getJavaType().getName();
                    if (name.equals(expected)) {
                        this.logTrace("Received expected result: " + name);
                        pass = true;
                    } else {
                        this.logTrace("Expected: " + expected + ", actual: " + name);
                    }
                } else {
                    this.logErr("getElementType() returned null");
                }
            } else {
                this.logErr("managedType() returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

