/*
 * Copyright (c) 2007, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * $Id$
 */

package com.sun.ts.tests.appclient.deploy.resref.scope;

import java.util.Properties;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.assembly.util.shared.resref.scope.TopicCode;

/** This client is never run by the TS harness */
public class TopicClient extends EETest {

	private TSNamingContext nctx = null;

	private Properties props = null;

	public static void main(String[] args) {
		TopicClient theTests = new TopicClient();
		Status s = theTests.run(args, System.out, System.err);
		s.exit();
	}

	/**
	 * @class.setup_props: org.omg.CORBA.ORBClass; java.naming.factory.initial;
	 */
	public void setup(String[] args, Properties props) throws Exception {
		this.props = props;

		try {
			nctx = new TSNamingContext();
			logMsg("[TopicClient] Setup succeed (got naming context).");
		} catch (Exception e) {
			throw new Exception("[TopicClient] Setup failed:", e);
		}
	}

	/* This method is never called by the TS harness */
	public void checkYourTopic() {
		TopicCode.checkYourTopic(nctx);
	}

	public void cleanup() throws Exception {
		logMsg("[TopicClient] cleanup()");
	}
}
