/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.LocalTransactionImpl;
import com.sun.ts.tests.common.connector.whitebox.MetaDataImpl;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionEventListener;
import com.sun.ts.tests.common.connector.whitebox.TSEISConnection;
import com.sun.ts.tests.common.connector.whitebox.TSXAConnection;
import com.sun.ts.tests.common.connector.whitebox.Util;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ManagedConnectionMetaData;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class TSManagedConnection
implements ManagedConnection {
    private TSXAConnection xacon;
    private TSConnection con;
    private TSConnectionEventListener jdbcListener;
    private PasswordCredential passCred;
    private ManagedConnectionFactory mcf;
    private PrintWriter logWriter;
    private boolean supportsXA;
    private boolean supportsLocalTx;
    private boolean destroyed;
    private Set connectionSet;

    public TSManagedConnection(ManagedConnectionFactory mcf, PasswordCredential passCred, TSXAConnection xacon, TSConnection con, boolean supportsXA, boolean supportsLocalTx) {
        this.mcf = mcf;
        this.passCred = passCred;
        this.xacon = xacon;
        this.con = con;
        this.supportsXA = supportsXA;
        this.supportsLocalTx = supportsLocalTx;
        this.connectionSet = new HashSet();
        this.jdbcListener = new TSConnectionEventListener(this);
        if (xacon != null) {
            xacon.addConnectionEventListener(this.jdbcListener);
        }
    }

    private void throwResourceException(Exception ex) throws ResourceException {
        ResourceException re = new ResourceException("Exception: " + ex.getMessage());
        re.initCause((Throwable)ex);
        throw re;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this.mcf, subject, connectionRequestInfo);
        if (!Util.isPasswordCredentialEqual(pc, this.passCred)) {
            throw new SecurityException("Principal does not match. Reauthentication not supported");
        }
        this.checkIfDestroyed();
        TSEISConnection jdbcCon = new TSEISConnection(this, this.supportsLocalTx);
        this.addTSConnection(jdbcCon);
        return jdbcCon;
    }

    public void destroy() throws ResourceException {
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            for (TSEISConnection jdbcCon : this.connectionSet) {
                jdbcCon.invalidate();
                ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.destroy", "", "");
            }
            this.connectionSet.clear();
            this.con.close();
            if (this.xacon != null) {
                this.xacon.close();
            }
        }
        catch (Exception ex) {
            this.throwResourceException(ex);
        }
    }

    public void cleanup() throws ResourceException {
        try {
            this.checkIfDestroyed();
            for (TSEISConnection jdbcCon : this.connectionSet) {
                jdbcCon.invalidate();
                ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.cleanup", "", "");
            }
            this.connectionSet.clear();
            if (this.xacon != null) {
                this.con.close();
                this.con = this.xacon.getConnection();
            } else if (this.con != null) {
                this.con.setAutoCommit(true);
            }
        }
        catch (Exception ex) {
            this.throwResourceException(ex);
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.checkIfDestroyed();
        if (!(connection instanceof TSEISConnection)) {
            throw new IllegalStateException("Invalid connection object: " + connection);
        }
        TSEISConnection jdbcCon = (TSEISConnection)connection;
        jdbcCon.associateConnection(this);
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.associateConnection", "connection", "");
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.addConnectionEventListener", "listener", "");
        this.jdbcListener.addConnectorListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.removeConnectionEventListener", "listener", "");
        this.jdbcListener.removeConnectorListener(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.supportsXA) {
            throw new NotSupportedException("XA transaction not supported");
        }
        try {
            this.checkIfDestroyed();
            ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.getXAResource", "", "xacon.getXAResource");
            return this.xacon.getXAResource(this);
        }
        catch (Exception ex) {
            this.throwResourceException(ex);
            return null;
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (!this.supportsLocalTx) {
            throw new NotSupportedException("Local transaction not supported");
        }
        this.checkIfDestroyed();
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.getLocalTransaction", "", "LocalTransactionImpl");
        return new LocalTransactionImpl(this);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new MetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public TSConnection getTSConnection() throws ResourceException {
        this.checkIfDestroyed();
        return this.con;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    public PasswordCredential getPasswordCredential() {
        return this.passCred;
    }

    void sendEvent(int eventType, Exception ex) {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.sendEvent", "eventType|ex", "");
        this.jdbcListener.sendEvent(eventType, ex, null);
    }

    void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.sendEvent", "eventType|ex|connectionHandle", "");
        this.jdbcListener.sendEvent(eventType, ex, connectionHandle);
    }

    public void removeTSConnection(TSEISConnection jdbcCon) {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.removeTSConnection", "jdbcCon", "");
        this.connectionSet.remove(jdbcCon);
    }

    public void addTSConnection(TSEISConnection jdbcCon) {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.addTSConnection", "jdbcCon", "");
        this.connectionSet.add(jdbcCon);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException("Managed connection is closed");
        }
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        ConnectorStatus.getConnectorStatus().logAPI("TSManagedConnection.getManagedConnectionFactory", "", "ManagedConnectionFactory");
        return this.mcf;
    }
}

