/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.basic.sharing;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.timer.basic.sharing.TimerIF;
import com.sun.ts.tests.ejb30.timer.common.ClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.ejb.EJB;
import jakarta.ejb.Timer;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class Client
extends ClientBase {
    private static final int THREAD_COUNT = 100;
    private static final long TIMER_DURATION = 300000L;
    @EJB(beanName="StatelessTimerBean")
    private TimerIF statelessTimerBean;
    @EJB(beanName="SingletonTimerBean")
    private TimerIF singletonTimerBean;

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        this.statelessTimerBean.cancelAllTimers();
        this.singletonTimerBean.cancelAllTimers();
    }

    public void createTimerRollbackStateless() {
        this.statelessTimerBean.createTimerRollback(100L, new TimerInfo(this.getTestName()));
        this.passIfNoTimeout(new long[0]);
    }

    public void createTimerRollbackSingleton() {
        this.singletonTimerBean.createTimerRollback(100L, new TimerInfo(this.getTestName()));
        this.passIfNoTimeout(new long[0]);
    }

    public void createVerifyRecurringTimerStateless() {
        Date expiration = TimerUtil.getCurrentDatePlus(13, 1);
        Timer timer = this.statelessTimerBean.createTimer(expiration, 100L, new TimerInfo(this.getTestName()));
        this.passIfRecurringTimeout(new long[0]);
        this.statelessTimerBean.cancelTimer(timer);
    }

    public void createVerifyRecurringTimerSingleton() {
        Date expiration = TimerUtil.getCurrentDatePlus(13, 1);
        Timer timer = this.singletonTimerBean.createTimer(expiration, 100L, new TimerInfo(this.getTestName()));
        this.passIfRecurringTimeout(new long[0]);
        this.singletonTimerBean.cancelTimer(timer);
    }

    public void accessTimersStateless() {
        this.accessTimers0(this.statelessTimerBean);
    }

    public void accessTimersSingleton() {
        this.accessTimers0(this.singletonTimerBean);
    }

    private void accessTimers0(final TimerIF bean) {
        int i;
        final Vector results = new Vector();
        final Vector errors = new Vector();
        bean.createTimer(300000L, null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String result = bean.accessTimers();
                    results.add(result);
                }
                catch (TestFailedException e) {
                    errors.add(TestUtil.printStackTraceToString((Throwable)e));
                }
            }
        };
        Thread[] threads = new Thread[100];
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(runnable);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.assertEquals(null, 0, errors.size());
        this.assertEquals(null, 100, results.size());
        this.appendReason(results);
        bean.cancelAllTimers();
    }
}

