/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.handler.Handler;
import com.sun.ts.tests.common.webclient.handler.HandlerFactory;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.common.webclient.http.HttpResponse;
import com.sun.ts.tests.common.webclient.validation.ValidationStrategy;
import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.Header;

public abstract class WebValidatorBase
implements ValidationStrategy {
    protected static final char CLIENT_ERROR = '4';
    protected static final char SERVER_ERROR = '5';
    protected HttpResponse _res = null;
    protected HttpRequest _req = null;
    protected WebTestCase _case = null;

    @Override
    public boolean validate(WebTestCase testCase) {
        this._res = testCase.getResponse();
        this._req = testCase.getRequest();
        this._case = testCase;
        try {
            if (!(this.checkStatusCode() && this.checkReasonPhrase() && this.checkExpectedHeaders() && this.checkUnexpectedHeaders() && this.checkSearchStrings() && this.checkSearchStringsNoCase() && this.checkUnorderedSearchStrings() && this.checkUnexpectedSearchStrings() && this.checkGoldenfile())) {
                return false;
            }
        }
        catch (IOException ioe) {
            TestUtil.logErr("[WebValidatorBase] Unexpected Exception: " + ioe.toString());
            return false;
        }
        return true;
    }

    protected boolean checkStatusCode() throws IOException {
        String[] sCodes;
        String sCode = this._case.getStatusCode();
        String resCode = this._res.getStatusCode();
        if ("-1".equals(sCode)) {
            return true;
        }
        if (sCode == null && resCode.charAt(0) == '4') {
            TestUtil.logErr("[WebValidatorBase] Unexpected " + resCode + " received from target server!  Request path: " + this._req.getRequestPath());
            return false;
        }
        if (sCode == null && resCode.charAt(0) == '5') {
            String resBody = this._res.getResponseBodyAsRawString();
            StringBuffer sb = new StringBuffer(75 + resBody.length());
            sb.append("[WebValidatorBase] Unexpected '");
            sb.append(resCode).append("' received from target server!\n");
            sb.append("Error response recieved from server:\n");
            sb.append("------------------------------------------------\n");
            sb.append(resBody != null ? resBody : "NO RESPONSE");
            TestUtil.logErr(sb.toString());
            return false;
        }
        if (sCode == null) {
            return true;
        }
        boolean exclusions = sCode.charAt(0) == '!';
        String[] stringArray = sCodes = exclusions ? sCode.substring(1).split(",") : sCode.split(",");
        if (exclusions) {
            for (String current : sCodes) {
                if (!current.equals(resCode)) continue;
                TestUtil.logErr("[WebValidatorBase] Unexpected Status Code recieved from server.  Expected any value except '" + sCode + "', received '" + resCode + "'");
                return false;
            }
        } else {
            boolean found = false;
            for (String current : sCodes) {
                if (!current.equals(resCode)) continue;
                TestUtil.logTrace("[WebValidatorBase] Expected Status Code '" + current + "' found in response line!");
                found = true;
                break;
            }
            if (!found) {
                TestUtil.logTrace("[WebValidatorBase] Status Code '" + sCode + "' not found in response line!");
                return false;
            }
        }
        return true;
    }

    protected boolean checkSearchStrings() throws IOException {
        List<String> list = this._case.getSearchStrings();
        boolean found = true;
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            String search = null;
            int n = list.size();
            int startIdx = 0;
            int bodyLength = responseBody.length();
            for (int i = 0; i < n; ++i) {
                if (startIdx >= bodyLength) {
                    startIdx = bodyLength;
                }
                search = list.get(i);
                int searchIdx = responseBody.indexOf(search, startIdx);
                TestUtil.logTrace("[WebValidatorBase] Scanning response for search string: '" + search + "' starting at index location: " + startIdx);
                if (searchIdx < 0) {
                    found = false;
                    StringBuffer sb = new StringBuffer(255);
                    sb.append("[WebValidatorBase] Unable to find the following ");
                    sb.append("search string in the server's ");
                    sb.append("response: '").append(search).append("' at index: ");
                    sb.append(startIdx);
                    sb.append("\n[WebValidatorBase] Server's response:\n");
                    sb.append("-------------------------------------------\n");
                    sb.append(responseBody);
                    sb.append("\n-------------------------------------------\n");
                    TestUtil.logErr(sb.toString());
                    break;
                }
                TestUtil.logTrace("[WebValidatorBase] Found search string: '" + search + "' at index '" + searchIdx + "' in the server's response");
                startIdx = searchIdx + search.length();
            }
        }
        return found;
    }

    protected boolean checkSearchStringsNoCase() throws IOException {
        List<String> list = this._case.getSearchStringsNoCase();
        boolean found = true;
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            String search = null;
            int n = list.size();
            int startIdx = 0;
            int bodyLength = responseBody.length();
            for (int i = 0; i < n; ++i) {
                if (startIdx >= bodyLength) {
                    startIdx = bodyLength;
                }
                search = list.get(i);
                int searchIdx = responseBody.toLowerCase().indexOf(search.toLowerCase(), startIdx);
                TestUtil.logTrace("[WebValidatorBase] Scanning response for search string: '" + search + "' starting at index location: " + startIdx);
                if (searchIdx < 0) {
                    found = false;
                    StringBuffer sb = new StringBuffer(255);
                    sb.append("[WebValidatorBase] Unable to find the following ");
                    sb.append("search string in the server's ");
                    sb.append("response: '").append(search).append("' at index: ");
                    sb.append(startIdx);
                    sb.append("\n[WebValidatorBase] Server's response:\n");
                    sb.append("-------------------------------------------\n");
                    sb.append(responseBody);
                    sb.append("\n-------------------------------------------\n");
                    TestUtil.logErr(sb.toString());
                    break;
                }
                TestUtil.logTrace("[WebValidatorBase] Found search string: '" + search + "' at index '" + searchIdx + "' in the server's response");
                startIdx = searchIdx + search.length();
            }
        }
        return found;
    }

    protected boolean checkUnorderedSearchStrings() throws IOException {
        List<String> list = this._case.getUnorderedSearchStrings();
        boolean found = true;
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            String search = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                search = list.get(i);
                int searchIdx = responseBody.indexOf(search);
                TestUtil.logTrace("[WebValidatorBase] Scanning response for search string: '" + search + "'...");
                if (searchIdx < 0) {
                    found = false;
                    StringBuffer sb = new StringBuffer(255);
                    sb.append("[WebValidatorBase] Unable to find the following ");
                    sb.append("search string in the server's ");
                    sb.append("response: '").append(search);
                    sb.append("\n[WebValidatorBase] Server's response:\n");
                    sb.append("-------------------------------------------\n");
                    sb.append(responseBody);
                    sb.append("\n-------------------------------------------\n");
                    TestUtil.logErr(sb.toString());
                    break;
                }
                TestUtil.logTrace("[WebValidatorBase] Found search string: '" + search + "' at index '" + searchIdx + "' in the server's response");
            }
        }
        return found;
    }

    protected boolean checkUnexpectedSearchStrings() throws IOException {
        List<String> list = this._case.getUnexpectedSearchStrings();
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            for (String search : list) {
                TestUtil.logTrace("[WebValidatorBase] Scanning response.  The following string should not be present in the response: '" + search + "'");
                if (responseBody.indexOf(search) <= -1) continue;
                StringBuffer sb = new StringBuffer(255);
                sb.append("[WebValidatorBase] Found the following unexpected ");
                sb.append("search string in the server's ");
                sb.append("response: '").append(search).append("'");
                sb.append("\n[WebValidatorBase] Server's response:\n");
                sb.append("-------------------------------------------\n");
                sb.append(responseBody);
                sb.append("\n-------------------------------------------\n");
                TestUtil.logErr(sb.toString());
                return false;
            }
        }
        return true;
    }

    protected abstract boolean checkGoldenfile() throws IOException;

    protected boolean checkReasonPhrase() {
        String sReason = this._case.getReasonPhrase();
        String resReason = this._res.getReasonPhrase();
        if (sReason == null) {
            return true;
        }
        return sReason.equalsIgnoreCase(resReason);
    }

    protected boolean checkExpectedHeaders() {
        Header[] expected = this._case.getExpectedHeaders();
        if (this.isEmpty(expected)) {
            return true;
        }
        boolean found = true;
        Header currentHeader = null;
        for (int i = 0; i < expected.length; ++i) {
            currentHeader = expected[i];
            Header resHeader = this._res.getResponseHeader(currentHeader.getName());
            if (resHeader != null) {
                Handler handler = HandlerFactory.getHandler(currentHeader.getName());
                if (handler.invoke(currentHeader, resHeader)) continue;
                found = false;
                break;
            }
            found = false;
            break;
        }
        if (!found) {
            StringBuffer sb = new StringBuffer(255);
            sb.append("[WebValidatorBase] Unable to find the following header");
            sb.append(" in the server's response: ");
            sb.append(currentHeader.toExternalForm()).append("\n");
            sb.append("[WebValidatorBase] Response headers recieved from");
            sb.append(" server:");
            Header[] resHeaders = this._res.getResponseHeaders();
            for (int i = 0; i < resHeaders.length; ++i) {
                sb.append("\n\tResponseHeader -> ");
                sb.append(resHeaders[i].toExternalForm());
            }
            sb.append("\n");
            TestUtil.logErr(sb.toString());
            return false;
        }
        TestUtil.logTrace("[WebValidatorBase] Found expected header: " + currentHeader.toExternalForm());
        return true;
    }

    protected boolean checkUnexpectedHeaders() {
        Header[] unexpected = this._case.getUnexpectedHeaders();
        if (this.isEmpty(unexpected)) {
            return true;
        }
        Header currentHeader = null;
        for (int i = 0; i < unexpected.length; ++i) {
            currentHeader = unexpected[i];
            String currName = currentHeader.getName();
            String currValue = currentHeader.getValue();
            Header resHeader = this._res.getResponseHeader(currName);
            if (resHeader == null || !resHeader.getValue().equals(currValue)) continue;
            StringBuffer sb = new StringBuffer(255);
            sb.append("[WebValidatorBase] Unexpected header found in the ");
            sb.append("server's response: ");
            sb.append(currentHeader.toExternalForm()).append("\n");
            sb.append("[WebValidatorBase] Response headers recieved from");
            sb.append("server:");
            Header[] resHeaders = this._res.getResponseHeaders();
            for (int j = 0; j < resHeaders.length; ++j) {
                sb.append("\n\tResponseHeader -> ");
                sb.append(resHeaders[j].toExternalForm());
            }
            sb.append("\n");
            TestUtil.logErr(sb.toString());
            return false;
        }
        return true;
    }

    protected boolean isEmpty(Header[] headers) {
        return headers == null || headers.length == 0;
    }
}

