/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.ra.activationconfig.common;

import com.sun.ts.tests.jms.ee20.ra.common.messaging.StatusReporter;
import com.sun.ts.tests.jms.ee20.ra.common.messaging.TLogger;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;

public abstract class ActivationConfigBeanBase {
    public static final String test1 = "test1";
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;

    public abstract EJBContext getEJBContext();

    public void onMessage(Message msg) {
        TLogger.log("Entering onMessage method of: " + this.getClass().getName());
        boolean status = false;
        String reason = null;
        String testname = null;
        int testNumber = 0;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            testNumber = msg.getIntProperty("TestCaseNum");
        }
        catch (JMSException e) {
            status = false;
            reason = "Failed to get test name/number from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
            return;
        }
        if (testname == null) {
            return;
        }
        status = true;
        reason = "ActivationConfigBeanBase received message from " + testname + ", testnum " + testNumber;
        TLogger.log(reason);
        StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
    }
}

