/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.AsyncAdminCommandInvoker;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import jakarta.ws.rs.core.Response;
import org.glassfish.admin.rest.utils.SseEventOutput;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.Job;

public class DetachedSseAdminCommandInvoker
extends AsyncAdminCommandInvoker<Response> {
    private static final System.Logger LOG = System.getLogger(DetachedSseAdminCommandInvoker.class.getName());
    private final Response.ResponseBuilder builder;

    public DetachedSseAdminCommandInvoker(CommandInvocation<AdminCommandJob> invocation, Response.ResponseBuilder builder) {
        super(invocation);
        this.builder = builder;
    }

    public Response start() {
        AdminCommandJob job = this.getJob();
        Response response = this.createResponse(job);
        LOG.log(System.Logger.Level.TRACE, "Job parameters: {0}, this: {1}", new Object[]{job.getParameters(), this});
        this.startJob();
        LOG.log(System.Logger.Level.TRACE, "Detached job started, leaving. {0}", new Object[]{this});
        return response;
    }

    private Response createResponse(AdminCommandJob job) {
        try (SseEventOutput eventOutput = new SseEventOutput(new DetachedAdminCommandState((Job)job));){
            LOG.log(System.Logger.Level.TRACE, "Writing the job id. {0}", new Object[]{this});
            eventOutput.write();
            Response response = this.builder.entity((Object)eventOutput).build();
            return response;
        }
    }

    private static final class DetachedAdminCommandState
    implements AdminCommandState {
        private final String id;
        private final String name;
        private final AdminCommandState.State state;

        DetachedAdminCommandState(Job job) {
            this.id = job.getId();
            this.name = job.getName();
            this.state = job.getState();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public AdminCommandState.State getState() {
            return this.state;
        }

        public ActionReport getActionReport() {
            PropsFileActionReporter actionReport = new PropsFileActionReporter();
            actionReport.setActionDescription(this.name + " command");
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return actionReport;
        }

        public boolean isOutboundPayloadEmpty() {
            return true;
        }
    }
}

