/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="migrate-timers")
@PerLookup
@I18n(value="migrate.timers")
@ExecuteOn(value={RuntimeType.INSTANCE}, ifNeverStarted=FailurePolicy.Error)
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="migrate-timers", description="Migrate Timers")})
public class MigrateTimers
implements AdminCommand {
    static StringManager localStrings = StringManager.getManager(MigrateTimers.class);
    private static final Logger logger = LogDomains.getLogger(MigrateTimers.class, (String)"jakarta.enterprise.system.container.ejb");
    @Param(name="target", optional=true, alias="destination", defaultValue="server")
    public String target;
    private boolean needRedirect;
    @Param(name="fromServer", primary=true, optional=false)
    public String fromServer;
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    private Domain domain;
    @Inject
    Target targetUtil;
    @Inject
    private ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String error = this.validate();
        if (error != null) {
            report.setMessage(error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (this.needRedirect) {
                this.needRedirect = false;
                ParameterMapExtractor mapExtractor = new ParameterMapExtractor(new Object[]{this});
                ParameterMap params = mapExtractor.extract();
                logger.info(localStrings.getString("migrate.timers.redirect", (Object)this.target, (Object)params.toCommaSeparatedString()));
                ClusterOperationUtil.replicateCommand((String)"migrate-timers", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Error, Arrays.asList(this.target), (AdminCommandContext)context, (ParameterMap)params, (ServiceLocator)this.habitat);
                return;
            }
            int totalTimersMigrated = this.migrateTimers(this.fromServer);
            report.setMessage(localStrings.getString("migrate.timers.count", (Object)totalTimersMigrated, (Object)this.fromServer, (Object)this.target));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private String validate() {
        Cluster fromServerCluster = this.targetUtil.getClusterForInstance(this.fromServer);
        if (fromServerCluster == null) {
            return localStrings.getString("migrate.timers.fromServerNotClusteredInstance", (Object)this.fromServer);
        }
        if (this.isServerRunning(this.fromServer)) {
            return localStrings.getString("migrate.timers.migrateFromServerStillRunning", (Object)this.fromServer);
        }
        if (this.target.equals("server")) {
            List instances = fromServerCluster.getInstances();
            for (Server instance : instances) {
                if (!instance.isListeningOnAdminPort()) continue;
                this.target = instance.getName();
                this.needRedirect = true;
            }
            if (this.target.equals("server")) {
                return localStrings.getString("migrate.timers.noRunningInstanceToChoose", (Object)this.target);
            }
        } else {
            Cluster destinationServerCluster = this.targetUtil.getClusterForInstance(this.target);
            if (!fromServerCluster.getName().equals(destinationServerCluster.getName())) {
                return localStrings.getString("migrate.timers.fromServerAndTargetNotInSameCluster", (Object)this.fromServer, (Object)this.target);
            }
            if (!this.isServerRunning(this.target)) {
                return localStrings.getString("migrate.timers.destinationServerIsNotAlive", (Object)this.target);
            }
        }
        return null;
    }

    private boolean isServerRunning(String serverName) {
        Server server = this.domain.getServerNamed(serverName);
        return server == null ? false : server.isListeningOnAdminPort();
    }

    private int migrateTimers(String serverId) {
        EJBTimerService ejbTimerService;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "[MigrateTimers] migrating timers from " + serverId);
        }
        int result = 0;
        if (EJBTimerService.isEJBTimerServiceLoaded() && (ejbTimerService = EJBTimerService.getEJBTimerService()) != null) {
            result = ejbTimerService.migrateTimers(serverId);
        }
        return result;
    }
}

