/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.taglibs.cache.CacheEntry;
import com.sun.appserv.web.taglibs.cache.CacheUtil;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.web.LogFacade;

public class CacheTag
extends BodyTagSupport {
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private String _keyExpr;
    private String _key;
    private int _timeout = 60;
    private boolean _refreshCache = false;
    private boolean _useCachedResponse = true;
    private int _scope = 4;
    private transient Cache _cache;
    private static final Logger _logger = LogFacade.getLogger();
    private static final ResourceBundle _rb = _logger.getResourceBundle();

    public int doStartTag() throws JspException {
        int ret = 2;
        this._key = CacheUtil.generateKey(this._keyExpr, this.pageContext);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AS-WEB-GLUE-00025", new Object[]{this._key, this._timeout});
        }
        if (this._useCachedResponse) {
            CacheEntry entry;
            this._cache = CacheUtil.getCache(this.pageContext, this._scope);
            if (this._cache == null) {
                throw new JspException(_rb.getString("AS-WEB-GLUE-00026"));
            }
            if (!this._refreshCache && (entry = (CacheEntry)this._cache.get((Object)this._key)) != null && entry.isValid()) {
                String content = entry.getContent();
                try {
                    this.pageContext.getOut().write(content);
                }
                catch (IOException ex) {
                    throw new JspException((Throwable)ex);
                }
                ret = 0;
            }
        } else {
            ret = 1;
        }
        return ret;
    }

    public int doAfterBody() throws JspException {
        if (this._useCachedResponse && this.bodyContent != null) {
            String content = this.bodyContent.getString().trim();
            CacheEntry entry = new CacheEntry(content, this._timeout);
            this._cache.put((Object)this._key, (Object)entry);
            try {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this._key = null;
        this._keyExpr = null;
        this._timeout = 60;
        this._refreshCache = false;
        this._useCachedResponse = true;
        this._scope = 4;
        this._cache = null;
        return 6;
    }

    public void setKey(String key) {
        if (key != null && key.length() > 0) {
            this._keyExpr = key;
        }
    }

    public void setTimeout(String timeout) {
        block10: {
            if (timeout != null) {
                try {
                    this._timeout = Integer.parseInt(timeout);
                }
                catch (NumberFormatException nfe) {
                    int i;
                    for (i = 0; i < timeout.length() && Character.isDigit(timeout.charAt(i)); ++i) {
                    }
                    if (i <= 0) break block10;
                    this._timeout = Integer.parseInt(timeout.substring(0, i));
                    char multiplier = timeout.charAt(i);
                    switch (multiplier) {
                        case 's': {
                            this._timeout *= 1;
                            break;
                        }
                        case 'm': {
                            this._timeout *= 60;
                            break;
                        }
                        case 'h': {
                            this._timeout *= 3600;
                            break;
                        }
                        case 'd': {
                            this._timeout *= 86400;
                            break;
                        }
                    }
                }
            }
        }
    }

    public void setNocache(boolean noCache) {
        if (noCache) {
            this._useCachedResponse = false;
        }
    }

    public void setRefresh(boolean refresh) {
        this._refreshCache = refresh;
    }

    public void setScope(String scope) {
        this._scope = CacheUtil.convertScope(scope);
    }
}

