/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.logging.WeldLogger;

public class UtilLogger_$logger
extends DelegatingBasicLogger
implements UtilLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UtilLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public UtilLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String classNotEnum$str() {
        return "WELD-000804: {0} is not an enum";
    }

    @Override
    public final IllegalArgumentException classNotEnum(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.classNotEnum$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String tooManyPostConstructMethods$str() {
        return "WELD-000805: Cannot have more than one post construct method annotated with @PostConstruct for {0}";
    }

    @Override
    public final DefinitionException tooManyPostConstructMethods(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.tooManyPostConstructMethods$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tooManyPreDestroyMethods$str() {
        return "WELD-000806: Cannot have more than one pre destroy method annotated @PreDestroy for {0}";
    }

    @Override
    public final DefinitionException tooManyPreDestroyMethods(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.tooManyPreDestroyMethods$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String initializerCannotBeProducer$str() {
        return "WELD-000807: Initializer method cannot be annotated @Produces {0}\n\tat {1}\n  StackTrace:";
    }

    @Override
    public final DefinitionException initializerCannotBeProducer(Object param1, Object stackElement) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.initializerCannotBeProducer$str(), param1, stackElement));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String initializerCannotBeDisposalMethod$str() {
        return "WELD-000808: Initializer method cannot have parameters annotated @Disposes: {0}\n\tat {1}\n  StackTrace:";
    }

    @Override
    public final DefinitionException initializerCannotBeDisposalMethod(Object param1, Object stackElement) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.initializerCannotBeDisposalMethod$str(), param1, stackElement));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String qualifierOnFinalField$str() {
        return "WELD-000810: Cannot place qualifiers on final fields:  {0}";
    }

    @Override
    public final DefinitionException qualifierOnFinalField(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.qualifierOnFinalField$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousConstructor$str() {
        return "WELD-000812: Cannot determine constructor to use for {0}. Possible constructors {1}";
    }

    @Override
    public final DefinitionException ambiguousConstructor(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.ambiguousConstructor$str(), param1, param2));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidQuantityInjectableFieldsAndInitializerMethods$str() {
        return "WELD-000813: injectableFields and initializerMethods must have the same size.\n\nInjectable Fields:  {0}\nInitializerMethods:  {1}";
    }

    @Override
    public final IllegalArgumentException invalidQuantityInjectableFieldsAndInitializerMethods(Object param1, Object param2) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidQuantityInjectableFieldsAndInitializerMethods$str(), param1, param2));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String annotationNotQualifier$str() {
        return "WELD-000814: Annotation {0} is not a qualifier";
    }

    @Override
    public final IllegalArgumentException annotationNotQualifier(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.annotationNotQualifier$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String redundantQualifier$str() {
        return "WELD-000815: Qualifier {0} is already present in the set {1}";
    }

    @Override
    public final IllegalArgumentException redundantQualifier(Object param1, Object param2) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.redundantQualifier$str(), param1, param2));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindConstructor$str() {
        return "WELD-000816: Cannot determine constructor to use for {0}";
    }

    @Override
    public final DefinitionException unableToFindConstructor(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.unableToFindConstructor$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindBeanDeploymentArchive$str() {
        return "WELD-000817: Unable to find Bean Deployment Archive for {0}";
    }

    @Override
    public final IllegalStateException unableToFindBeanDeploymentArchive(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToFindBeanDeploymentArchive$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String eventTypeNotAllowed$str() {
        return "WELD-000818: Event type {0} is not allowed";
    }

    @Override
    public final IllegalArgumentException eventTypeNotAllowed(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.eventTypeNotAllowed$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String typeParameterNotAllowedInEventType$str() {
        return "WELD-000819: Cannot provide an event type parameterized with a type parameter {0}";
    }

    @Override
    public final IllegalArgumentException typeParameterNotAllowedInEventType(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.typeParameterNotAllowedInEventType$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotProxyNonClassType$str() {
        return "WELD-000820: Cannot proxy non-Class Type {0}";
    }

    @Override
    public final IllegalArgumentException cannotProxyNonClassType(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.cannotProxyNonClassType$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String accessErrorOnField$str() {
        return "WELD-000824: Error getting field {0} on {1}";
    }

    @Override
    public final WeldException accessErrorOnField(Object param1, Object param2, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.accessErrorOnField$str(), param1, param2), cause);
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String annotationValuesInaccessible$str() {
        return "WELD-000826: Cannot access values() on annotation";
    }

    @Override
    public final DeploymentException annotationValuesInaccessible(Throwable cause) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.annotationValuesInaccessible$str(), new Object[0]), cause);
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String initializerMethodIsGeneric$str() {
        return "WELD-000827: Initializer method may not be a generic method: {0}\n\tat {1}\n  StackTrace:";
    }

    @Override
    public final DefinitionException initializerMethodIsGeneric(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.initializerMethodIsGeneric$str(), param1, param2));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceSetterInjectionNotAJavabean$str() {
        return "WELD-000833: Resource injection point represents a method which doesn't follow JavaBean conventions {0}";
    }

    @Override
    public final DefinitionException resourceSetterInjectionNotAJavabean(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.resourceSetterInjectionNotAJavabean$str(), param1));
        UtilLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToInjectResource(Object member, Object stackElement) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToInjectResource$str(), member, stackElement);
    }

    protected String unableToInjectResource$str() {
        return "WELD-000834: Unable to inject resource - most probably incorrect InjectionServices SPI implementation: {0}\n\tat {1}";
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

