/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt.report;

import java.io.BufferedWriter;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logging.processor.apt.report.IndentingXmlWriter;
import org.jboss.logging.processor.apt.report.ReportType;
import org.jboss.logging.processor.apt.report.ReportWriter;
import org.jboss.logging.processor.model.LoggerMessageMethod;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class XmlReportWriter
extends ReportWriter {
    private static final String NAMESPACE = "urn:jboss:logging:report:1.0";
    private final XMLStreamWriter xmlWriter;

    XmlReportWriter(MessageInterface messageInterface, BufferedWriter writer) throws XMLStreamException {
        super(messageInterface);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.xmlWriter = new IndentingXmlWriter(factory.createXMLStreamWriter(writer));
    }

    @Override
    public void writeHeader(String title) throws IOException {
        try {
            this.xmlWriter.writeStartDocument();
            this.xmlWriter.setDefaultNamespace(NAMESPACE);
            this.xmlWriter.writeStartElement("report");
            this.xmlWriter.writeNamespace(null, NAMESPACE);
            if (title != null) {
                this.xmlWriter.writeAttribute("title", title);
            }
            this.xmlWriter.writeStartElement("messages");
            this.xmlWriter.writeAttribute("interface", this.messageInterface.name());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeDetail(MessageMethod messageMethod) throws IOException {
        try {
            String url;
            this.xmlWriter.writeStartElement("message");
            MessageMethod.Message msg = messageMethod.message();
            if (msg.hasId()) {
                String id = String.format(this.messageIdFormat, msg.id());
                this.xmlWriter.writeAttribute("id", id);
                url = this.getUrl(messageMethod, id);
            } else {
                url = this.getUrl(messageMethod, "--");
            }
            if (!url.isEmpty()) {
                this.xmlWriter.writeAttribute("resolutionUrl", url);
            }
            if (messageMethod instanceof LoggerMessageMethod) {
                this.xmlWriter.writeAttribute("logLevel", this.getLogLevel((LoggerMessageMethod)messageMethod));
            } else {
                this.xmlWriter.writeAttribute("returnType", messageMethod.returnType().name());
            }
            this.xmlWriter.writeCharacters(msg.value());
            this.xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeFooter() throws IOException {
        try {
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.xmlWriter != null) {
                this.xmlWriter.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    @Override
    ReportType getReportType() {
        return ReportType.XML;
    }
}

