/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.impl.util.GlassFishObjectInputStream;
import com.sun.enterprise.container.common.impl.util.GlassFishObjectOutputStream;
import com.sun.enterprise.container.common.spi.util.GlassFishInputStreamHandler;
import com.sun.enterprise.container.common.spi.util.GlassFishOutputStreamHandler;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEEIOUtilsImpl
implements JavaEEIOUtils {
    private static final Logger LOG = LogDomains.getLogger(JavaEEIOUtilsImpl.class, (String)"jakarta.enterprise.system.core.naming", (boolean)false);
    private final Collection<GlassFishOutputStreamHandler> outputHandlers = new HashSet<GlassFishOutputStreamHandler>();
    private final Collection<GlassFishInputStreamHandler> inputHandlers = new HashSet<GlassFishInputStreamHandler>();
    @Inject
    private ServiceLocator habitat;

    @Override
    public ObjectInputStream createObjectInputStream(InputStream is, boolean resolveObject, ClassLoader loader) throws Exception {
        return new GlassFishObjectInputStream(this.inputHandlers, is, loader, resolveObject);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream os, boolean replaceObject) throws IOException {
        return new GlassFishObjectOutputStream(this.outputHandlers, os, replaceObject);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "serializeObject(object={0}, replaceObject={1})", new Object[]{obj, replaceObject});
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            block15: {
                ObjectOutputStream oos = this.createObjectOutputStream(bos, replaceObject);
                try {
                    oos.writeObject(obj);
                    oos.flush();
                    byArray = bos.toByteArray();
                    if (oos == null) break block15;
                }
                catch (Throwable throwable) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                oos.close();
            }
            return byArray;
        }
        catch (NotSerializableException notSerEx) {
            throw notSerEx;
        }
        catch (Exception th) {
            throw new IOException("Serialization failed.", th);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserializeObject(byte[] data, boolean resolveObject, ClassLoader appClassLoader) throws Exception {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "deserializeObject(data, resolveObject={0}, appClassLoader)", resolveObject);
        }
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            Object object;
            block14: {
                ObjectInputStream ois = this.createObjectInputStream(bis, resolveObject, appClassLoader);
                try {
                    object = ois.readObject();
                    if (ois == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ois.close();
            }
            return object;
        }
    }

    @Override
    public void addGlassFishOutputStreamHandler(GlassFishOutputStreamHandler handler) {
        this.outputHandlers.add(handler);
    }

    @Override
    public void removeGlassFishOutputStreamHandler(GlassFishOutputStreamHandler handler) {
        this.outputHandlers.remove(handler);
    }

    @Override
    public void addGlassFishInputStreamHandler(GlassFishInputStreamHandler handler) {
        this.inputHandlers.add(handler);
    }

    @Override
    public void removeGlassFishInputStreamHandler(GlassFishInputStreamHandler handler) {
        this.inputHandlers.remove(handler);
    }
}

