/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceLocator {
    private static final Logger LOG = Logger.getLogger(ResourceLocator.class.getName());
    private final URLClassLoader classLoader;
    private final ClassLoader delegate;
    private final boolean prioritizeDelegate;

    public ResourceLocator(URLClassLoader classLoader, ClassLoader delegate, boolean prioritizeDelegate) {
        this.classLoader = classLoader;
        this.delegate = delegate;
        this.prioritizeDelegate = prioritizeDelegate;
    }

    public boolean isOverridableResource(String name) {
        return "META-INF/services/jakarta.json.spi.JsonProvider".equals(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        LOG.log(Level.FINEST, "getResources({0})", name);
        final Enumeration[] enums = new Enumeration[2];
        Enumeration<URL> localResources = this.classLoader.findResources(name);
        if (localResources.hasMoreElements() && this.isOverridableResource(name)) {
            return localResources;
        }
        Enumeration<URL> delegateResources = this.delegate.getResources(name);
        if (this.prioritizeDelegate) {
            enums[0] = delegateResources;
            enums[1] = localResources;
        } else {
            enums[1] = delegateResources;
            enums[0] = localResources;
        }
        return new Enumeration<URL>(this){
            int index = 0;

            private boolean next() {
                while (this.index < enums.length) {
                    if (enums[this.index] != null && enums[this.index].hasMoreElements()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                return (URL)enums[this.index].nextElement();
            }
        };
    }
}

