/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.Attribute;
import org.eclipse.persistence.asm.ClassReader;
import org.eclipse.persistence.asm.ClassVisitor;
import org.eclipse.persistence.asm.internal.platform.eclipselink.ClassReaderImpl;

public class EclipseLinkClassReader
extends ClassReader {
    private ClassReader classReader;

    public EclipseLinkClassReader(InputStream stream) throws IOException {
        this(EclipseLinkClassReader.getStream(stream));
    }

    public EclipseLinkClassReader(byte[] classFile) throws IOException {
        this(classFile, 0, classFile.length);
    }

    public EclipseLinkClassReader(byte[] classFileBuffer, int classFileOffset, int classFileLength) throws IOException {
        this.classReader = ASMFactory.createClassReader(classFileBuffer, classFileOffset, classFileLength);
    }

    private static byte[] getStream(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
            outputStream.write(data, 0, bytesRead);
        }
        outputStream.flush();
        return outputStream.toByteArray();
    }

    @Override
    public void accept(ClassVisitor classVisitor, int parsingOptions) {
        this.classReader.accept(classVisitor, parsingOptions);
    }

    @Override
    public void accept(ClassVisitor classVisitor, Attribute[] attributePrototypes, int parsingOptions) {
        this.classReader.accept(classVisitor, attributePrototypes, parsingOptions);
    }

    @Override
    public int getAccess() {
        return this.classReader.getAccess();
    }

    @Override
    public String getSuperName() {
        return this.classReader.getSuperName();
    }

    @Override
    public String[] getInterfaces() {
        return this.classReader.getInterfaces();
    }

    @Override
    public <T> T unwrap() {
        if (this.classReader instanceof org.eclipse.persistence.asm.internal.platform.ow2.ClassReaderImpl) {
            return (T)((org.eclipse.persistence.asm.internal.platform.ow2.ClassReaderImpl)this.classReader).getInternal();
        }
        if (this.classReader instanceof ClassReaderImpl) {
            return (T)((ClassReaderImpl)this.classReader).getInternal();
        }
        return null;
    }
}

