/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.valueexpression;

import com.sun.ts.tests.el.common.api.expression.ExpressionTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private Hashtable<Class<?>, Object> testValueTable;
    private Properties testProps;

    public ELClientIT() {
        this.initializeTable();
        this.testProps = System.getProperties();
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void positiveValueExpressionTest() throws Exception {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        StringBuffer buf = new StringBuffer();
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new SimpleELContext().getELContext();
            ELResolver resolver = context.getELResolver();
            resolver.setValue(context, null, (Object)"foo", (Object)"bar");
            buf.append("Testing expression 1 " + ELTestUtil.NL);
            String exprStr1 = "${foo}";
            ValueExpression vexp1 = expFactory.createValueExpression(context, exprStr1, String.class);
            pass1 = ExpressionTest.testValueExpression(vexp1, context, exprStr1, String.class, "bar", false, false, buf);
            buf.append("Testing expression 2 " + ELTestUtil.NL);
            String exprStr2 = "foo";
            ValueExpression vexp2 = expFactory.createValueExpression(context, exprStr2, String.class);
            pass2 = ExpressionTest.testValueExpression(vexp2, context, exprStr2, String.class, "foo", true, true, buf);
            buf.append("Testing expression 3 " + ELTestUtil.NL);
            String exprStr3 = "#{1 + 1}";
            ValueExpression vexp3 = expFactory.createValueExpression(context, exprStr3, Integer.class);
            pass3 = ExpressionTest.testValueExpression(vexp3, context, exprStr3, Integer.class, 2, true, false, buf);
            buf.append("Testing expression 4 " + ELTestUtil.NL);
            pass4 = true;
            VRContext contextTwo = new VRContext(this.testProps);
            String exprStr4 = "#{worker.lastName}";
            ValueExpression vexp4 = expFactory.createValueExpression((ELContext)contextTwo, exprStr4, String.class);
            ValueReference vr = vexp4.getValueReference((ELContext)contextTwo);
            if (vr == null) {
                pass4 = false;
                buf.append("ValueRefernce should have return a non null value.");
            } else {
                String baseName;
                Object base = vr.getBase();
                if (base != null && !"Worker".equals(baseName = base.getClass().getSimpleName())) {
                    buf.append("Unexpected Base Value!" + ELTestUtil.NL + "Expected: Worker" + ELTestUtil.NL + "Received: " + baseName);
                    pass4 = false;
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void negativeValueExpressionTest() throws Exception {
        boolean pass = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext simpleContext = new SimpleELContext().getELContext();
        ELContext emptyContext = new BareBonesELContext().getELContext();
        ELResolver resolver = simpleContext.getELResolver();
        try {
            resolver.setValue(simpleContext, null, (Object)"foo", (Object)"bar");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        String exprStr = "${foo}";
        ValueExpression vexp = expFactory.createValueExpression(simpleContext, exprStr, String.class);
        try {
            vexp.getValue(null);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getValue() with null ELContext parameter did not" + ELTestUtil.NL + " cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getValue() with null ELContext parameter caused an exception to be thrown, but it was not a" + ELTestUtil.NL + " NullPointerException: " + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.setValue(null, (Object)"foo");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to setValue() with null ELContext parameter did not" + ELTestUtil.NL + " cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to setValue() with null ELContext parameter caused" + ELTestUtil.NL + " an exception to be thrown, but it was not a" + ELTestUtil.NL + " NullPointerException: " + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.isReadOnly(null);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to isReadOTestUtil.NEW_LINEy() with null ELContext parameter did not" + ELTestUtil.NL + " cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to isReadOTestUtil.NEW_LINEy() with null ELContext parameter caused" + ELTestUtil.NL + "an exception to be thrown, but it was not a" + ELTestUtil.NL + "NullPointerException: " + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.getType(null);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getType() with null ELContext parameter did not" + ELTestUtil.NL + "cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getType() with null ELContext parameter caused" + ELTestUtil.NL + "an exception to be thrown, but it was not a" + ELTestUtil.NL + "NullPointerException: " + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.setValue(emptyContext, (Object)"foo");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to setValue() for non-existent property did not cause" + ELTestUtil.NL + "an exception to be thrown" + ELTestUtil.NL);
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to setValue() for non-existent property caused an exception to be thrown, but it was not a" + ELTestUtil.NL + "PropertyNotFoundException: " + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.getValue(emptyContext);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getValue() for non-existent property did not cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getValue() for non-existent property caused an exception to be thrown, but it was not a PropertyNotFoundException: " + ELTestUtil.NL + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.isReadOnly(emptyContext);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to isReadOTestUtil.NEW_LINEy() for non-existent property did not cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to isReadOTestUtil.NEW_LINEy() for non-existent property caused an exception to be thrown, but it was not a PropertyNotFoundException: " + ELTestUtil.NL + e.toString() + ELTestUtil.NL);
        }
        try {
            vexp.getType(emptyContext);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getType() for non-existent property did not cause an exception to be thrown" + ELTestUtil.NL);
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getType() for non-existent property caused an exception to be thrown, but it was not a" + ELTestUtil.NL + " PropertyNotFoundException: " + e.toString() + ELTestUtil.NL);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void valueExpressionSerializableTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        Enumeration<Class<?>> keys = this.testValueTable.keys();
        while (keys.hasMoreElements()) {
            boolean pass = true;
            Class<?> testClass = keys.nextElement();
            Object testValue = this.testValueTable.get(testClass);
            try {
                ExpressionFactory expFactory = ExpressionFactory.newInstance();
                ELContext context = new SimpleELContext().getELContext();
                ValueExpression evalvexp = expFactory.createValueExpression(context, "${" + testValue + "}", testClass);
                logger.log(System.Logger.Level.TRACE, "Eval Value Expression For Testing: " + evalvexp.toString() + ELTestUtil.NL);
                ValueExpression literalvexp = expFactory.createValueExpression(context, "\"" + testValue + "\"", testClass);
                logger.log(System.Logger.Level.TRACE, "Literal Value Expression For Testing: " + literalvexp.toString() + ELTestUtil.NL);
                ValueExpression compositevexp = expFactory.createValueExpression(context, "#{" + testValue + "} " + testValue, testClass);
                logger.log(System.Logger.Level.TRACE, "Composite Value Expression For Testing: " + compositevexp.toString() + ELTestUtil.NL);
                if (!(ExpressionTest.expressionSerializableTest((Expression)evalvexp, buf) && ExpressionTest.expressionSerializableTest((Expression)literalvexp, buf) && ExpressionTest.expressionSerializableTest((Expression)compositevexp, buf))) {
                    pass = false;
                    break;
                }
            }
            catch (Exception ex) {
                throw new Exception(ex);
            }
            if (pass) {
                logger.log(System.Logger.Level.TRACE, buf.toString());
                continue;
            }
            throw new Exception("Test FAILED" + buf.toString());
        }
    }

    private void initializeTable() {
        this.testValueTable = new Hashtable();
        this.testValueTable.put(String.class, "SERIAL");
        this.testValueTable.put(Integer.class, Integer.valueOf("123"));
        this.testValueTable.put(Boolean.class, Boolean.TRUE);
    }

    @Test
    public void valueExpressionEqualsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        try {
            ValueExpression vexp10;
            ValueExpression vexp8;
            ValueExpression vexp6;
            ValueExpression vexp4;
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            ELResolver resolver = context.getELResolver();
            String exprStr1 = "${foo}";
            String exprStr2 = "${bar}";
            resolver.setValue((ELContext)context, null, (Object)"foo", (Object)"SOME VALUE");
            resolver.setValue((ELContext)context, null, (Object)"bar", (Object)"SOME VALUE");
            ValueExpression vexp1 = expFactory.createValueExpression((ELContext)context, exprStr1, String.class);
            ValueExpression vexp2 = expFactory.createValueExpression((ELContext)context, exprStr2, String.class);
            buf.append("vexp1 has value " + (String)vexp1.getValue((ELContext)context) + ELTestUtil.NL);
            buf.append("vexp2 has value " + (String)vexp2.getValue((ELContext)context) + ELTestUtil.NL);
            if (ExpressionTest.equalsTest((Expression)vexp1, (Expression)vexp2, buf)) {
                pass = false;
                buf.append("Failed: case 1: same type and equal value" + ELTestUtil.NL);
            }
            String exprStr3 = "${A+B+C}";
            String exprStr4 = "${ A + B\t+\t\tC\t}";
            ValueExpression vexp3 = expFactory.createValueExpression((ELContext)context, exprStr3, Object.class);
            if (!ExpressionTest.equalsTest((Expression)vexp3, (Expression)(vexp4 = expFactory.createValueExpression((ELContext)context, exprStr4, Object.class)), buf)) {
                buf.append("Failed: case 2: white space" + ELTestUtil.NL);
                pass = false;
            }
            String exprStr5 = "${A < B}";
            String exprStr6 = "${A lt B}";
            ValueExpression vexp5 = expFactory.createValueExpression((ELContext)context, exprStr5, Object.class);
            if (!ExpressionTest.equalsTest((Expression)vexp5, (Expression)(vexp6 = expFactory.createValueExpression((ELContext)context, exprStr6, Object.class)), buf)) {
                buf.append("Failed: case 3: equivalent operators" + ELTestUtil.NL);
                pass = false;
            }
            String exprStr7 = "${A + B}";
            String exprStr8 = "${B + A}";
            ValueExpression vexp7 = expFactory.createValueExpression((ELContext)context, exprStr7, Object.class);
            if (ExpressionTest.equalsTest((Expression)vexp7, (Expression)(vexp8 = expFactory.createValueExpression((ELContext)context, exprStr8, Object.class)), buf)) {
                buf.append("Failed: case 4: reversed operands" + ELTestUtil.NL);
                pass = false;
            }
            String exprStr9 = "${A}";
            String exprStr10 = "#{A}";
            ValueExpression vexp9 = expFactory.createValueExpression((ELContext)context, exprStr9, Object.class);
            if (!ExpressionTest.equalsTest((Expression)vexp9, (Expression)(vexp10 = expFactory.createValueExpression((ELContext)context, exprStr10, Object.class)), buf)) {
                buf.append("Failed: case 5: delimiters" + ELTestUtil.NL);
                pass = false;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

