/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.lang.reflect.Field;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GradientTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);
    public static CSSEngine engine;

    protected CTabFolder createTestCTabFolder(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderToTest = new CTabFolder(panel, 0);
        CTabItem tab1 = new CTabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        engine.applyStyles((Object)folderToTest, true);
        shell.pack();
        return folderToTest;
    }

    public void testGradients() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #0000FF}");
        GradientTest.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
    }

    public void testDefaultPercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #0000FF}");
        GradientTest.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        GradientTest.assertEquals(new int[]{100}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testDefaultManyPercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: red green blue yellow}");
        GradientTest.assertEquals(new int[]{33, 67, 100}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testSpecifiedPercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #0000FF 53%}");
        GradientTest.assertEquals(new int[]{53}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testManyColorsAndSpecifiedManyPercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #00FF00 #0000FF 22% 44%}");
        GradientTest.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)GREEN, (Object)this.getSelectionBackground(folderToTest, 1).getRGB());
        GradientTest.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        GradientTest.assertEquals(new int[]{22, 44}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testBadPercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: red green blue yellow 10%}");
        GradientTest.assertEquals(new int[]{33, 67, 100}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testBadColors() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 notAColor #0000FF}");
        GradientTest.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        GradientTest.assertEquals(new int[]{100}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testAboveRangePercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #00FF00 #0000FF 20% 110%}");
        GradientTest.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        GradientTest.assertEquals(new int[]{50, 100}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testBelowRangePercents() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #00FF00 #0000FF -20% 50%}");
        GradientTest.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        GradientTest.assertEquals(new int[]{50, 100}, this.getSelectionGradientPercents(folderToTest));
    }

    public void testAltSyntax() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: gradient, rgb(140,140,140), rgb(48,48,48), 100%;");
        GradientTest.assertEquals((Object)new RGB(140, 140, 140), (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        GradientTest.assertEquals((Object)new RGB(48, 48, 48), (Object)folderToTest.getSelectionBackground().getRGB());
        GradientTest.assertEquals(new int[]{100}, this.getSelectionGradientPercents(folderToTest));
    }

    Color getSelectionBackgroundBegin(CTabFolder folder) {
        return this.getSelectionBackground(folder, 0);
    }

    Color getSelectionBackground(CTabFolder folder, int i) {
        try {
            Field field = folder.getClass().getDeclaredField("selectionGradientColors");
            field.setAccessible(true);
            return ((Color[])field.get(folder))[i];
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    int[] getSelectionGradientPercents(CTabFolder folder) {
        try {
            Field field = folder.getClass().getDeclaredField("selectionGradientPercents");
            field.setAccessible(true);
            return (int[])field.get(folder);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

