/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.mozilla.javascript.Function;

public class JavascriptNotificationSupport
extends EContentAdapter {
    private JavascriptSupport javascriptSupport;
    private static StringBuilder methodName = new StringBuilder();
    private boolean rethrowException = false;

    private JavascriptNotificationSupport(JavascriptSupport javascriptSupport) {
        this.javascriptSupport = javascriptSupport;
    }

    JavascriptNotificationSupport(JavascriptSupport javascriptSupport, Notifier notifier) {
        this(javascriptSupport);
        this.addAdapter(notifier);
    }

    protected void addAdapter(Notifier notifier) {
        if (!notifier.eAdapters().contains((Object)this)) {
            super.addAdapter(notifier);
        } else {
            System.err.println("Duplicate JavascriptNotificationSupport adapter for " + notifier);
        }
    }

    protected void setTarget(EObject target) {
        super.setTarget(target);
    }

    private static String getEventName(int eventType) {
        String eventName = "Change";
        switch (eventType) {
            case 1: {
                eventName = "Set";
                break;
            }
            case 2: {
                eventName = "Unset";
                break;
            }
            case 3: {
                eventName = "Add";
                break;
            }
            case 4: {
                eventName = "Remove";
                break;
            }
            case 5: {
                eventName = "AddMany";
                break;
            }
            case 6: {
                eventName = "RemoveMany";
                break;
            }
            case 7: {
                eventName = "Move";
            }
        }
        return eventName;
    }

    private static String getMethodName(EStructuralFeature feature, int eventType) {
        methodName.setLength(0);
        String eventName = JavascriptNotificationSupport.getEventName(eventType);
        String featureName = feature.getName();
        methodName.append("on");
        methodName.append(eventName);
        char first = featureName.charAt(0);
        if (Character.isUpperCase(first)) {
            methodName.append(featureName);
        } else {
            methodName.append(Character.toUpperCase(first));
            methodName.append(featureName, 1, featureName.length());
        }
        return methodName.toString().intern();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object source = notification.getNotifier();
        if (source instanceof EObject) {
            JavascriptNotificationSupport.notifyChanged(notification, (EObject)source, this.javascriptSupport, this.rethrowException);
        }
    }

    static void notifyChanged(Notification notification, EObject handler, JavascriptSupport javascriptSupport, boolean rethrowException) {
        Object feature = notification.getFeature();
        if (feature instanceof EStructuralFeature) {
            String specificMethodName = JavascriptNotificationSupport.getMethodName((EStructuralFeature)feature, notification.getEventType());
            String genericMethodName = JavascriptNotificationSupport.getMethodName((EStructuralFeature)feature, -1);
            Object[] methodArgs = new Object[]{notification};
            if (javascriptSupport.getProperty(handler, specificMethodName) instanceof Function) {
                javascriptSupport.callMethod(handler, specificMethodName, methodArgs, rethrowException);
            } else if (javascriptSupport.getProperty(handler, genericMethodName) instanceof Function) {
                javascriptSupport.callMethod(handler, genericMethodName, methodArgs, rethrowException);
            } else if (javascriptSupport.getVariable(handler.eResource(), specificMethodName) instanceof Function) {
                javascriptSupport.callFunction(handler.eResource(), specificMethodName, methodArgs, rethrowException);
            } else if (javascriptSupport.getVariable(handler.eResource(), genericMethodName) instanceof Function) {
                javascriptSupport.callFunction(handler.eResource(), genericMethodName, methodArgs, rethrowException);
            }
        }
    }
}

