/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.List;
import org.eclipse.e4.emf.ecore.javascript.JavascriptNotificationSupport;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavascriptSupportWrapper
extends NativeJavaObject
implements Adapter {
    protected final JavascriptSupport javascriptSupport;
    private boolean emfOnly = false;

    public boolean isEmfOnly() {
        return this.emfOnly;
    }

    public void setEmfOnly(boolean emfOnly) {
        this.emfOnly = emfOnly;
    }

    JavascriptSupportWrapper(JavascriptSupport javascriptSupport, Scriptable scope, Object object, Class<?> staticType, EClassifier prototypeClass) {
        super(scope, object, staticType);
        this.javascriptSupport = javascriptSupport;
        javascriptSupport.initWrapper(this, scope, object, prototypeClass);
    }

    static String toString(String wrapperName, Object o) {
        boolean isEObject = o instanceof EObject;
        return "[" + wrapperName + " for " + (isEObject ? "eO" : "o") + "bject of " + (isEObject ? "eClass " + ((EObject)o).eClass().getName() : o.getClass()) + ": " + o;
    }

    public String toString() {
        return JavascriptSupportWrapper.toString("JSWrapper", this.javaObject);
    }

    protected void addIndexIds(int n, List<Object> l) {
        int i = 0;
        while (i < n) {
            l.add(i);
            ++i;
        }
    }

    protected void addParentId(EObject eObject, List<Object> result) {
        if (eObject.eContainingFeature() != null) {
            result.add("$");
        }
    }

    protected void addNameIds(List<EObject> contents, List<Object> result) {
        for (EObject content : contents) {
            String eName = this.javascriptSupport.getName(content);
            if (eName == null) continue;
            result.add("$" + eName);
        }
        int i = 0;
        while (i < result.size()) {
            Object id = result.get(i);
            if (id instanceof ENamedElement) {
                result.set(i, ((ENamedElement)id).getName());
            }
            ++i;
        }
    }

    public boolean has(String name, Scriptable start) {
        return this.isEmfOnly() ? false : super.has(name, start);
    }

    public Object get(String name, Scriptable start) {
        return this.isEmfOnly() ? Scriptable.NOT_FOUND : super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        if (!this.isEmfOnly()) {
            super.put(name, start, value);
        }
    }

    protected boolean has(List<?> list, int index, Scriptable start) {
        return list.size() > index;
    }

    protected Object get(List<?> list, int index, Scriptable start) {
        return this.javascriptSupport.wrap(list.get(index));
    }

    protected void put(List list, int index, Scriptable start, Object value) {
        value = this.javascriptSupport.unwrap(value);
        list.set(index, value);
    }

    public Notifier getTarget() {
        return this.javaObject instanceof EObject ? (EObject)this.javaObject : null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        if (this.javaObject instanceof EObject) {
            JavascriptNotificationSupport.notifyChanged(notification, (EObject)this.javaObject, this.javascriptSupport, false);
        }
    }
}

