/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.controls.combo;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.controls.combo.Combo_Styles;
import org.eclipse.swt.widgets.Combo;

public class ComboTests
extends XWTTestCase {
    public void testComboStyle() throws Exception {
        Runnable prepare = new Runnable(){

            public void run() {
            }
        };
        Runnable checker = new Runnable(){

            public void run() {
                this.checkComboStyle("combo1", 4);
                this.checkComboStyle("combo2", 12);
                this.checkComboStyle("combo3", 64);
            }

            public void checkComboStyle(String name, int style) {
                Object element = XWT.findElementByName((Object)ComboTests.this.root, (String)name);
                ComboTests.assertTrue((boolean)(element instanceof Combo));
                Combo combo = (Combo)element;
                ComboTests.assertTrue(((combo.getStyle() & style) == style ? 1 : 0) != 0);
            }
        };
        URL url = Combo_Styles.class.getResource(String.valueOf(Combo_Styles.class.getSimpleName()) + ".xwt");
        this.runTest(url, prepare, checker);
    }

    public void testComboItems() throws Exception {
        Runnable prepare = new Runnable(){

            public void run() {
            }
        };
        Runnable checker = new Runnable(){

            public void run() {
                this.checkComboItems("combo1", new String[]{"Item1", "Item2", "Item3", "Item4"});
            }

            public void checkComboItems(String name, String[] items) {
                Object element = XWT.findElementByName((Object)ComboTests.this.root, (String)name);
                ComboTests.assertTrue((boolean)(element instanceof Combo));
                Combo combo = (Combo)element;
                ComboTests.this.assertEqualsArray(combo.getItems(), items);
            }
        };
        URL url = Combo_Styles.class.getResource(String.valueOf(Combo_Styles.class.getSimpleName()) + ".xwt");
        this.runTest(url, prepare, checker);
    }

    public void testComboText() throws Exception {
        Runnable prepare = new Runnable(){

            public void run() {
            }
        };
        Runnable checker = new Runnable(){

            public void run() {
                this.checkComboText("combo3", "Item3");
            }

            public void checkComboText(String name, String item) {
                Object element = XWT.findElementByName((Object)ComboTests.this.root, (String)name);
                ComboTests.assertTrue((boolean)(element instanceof Combo));
                Combo combo = (Combo)element;
                ComboTests.assertEquals((String)combo.getText(), (String)item);
            }
        };
        URL url = Combo_Styles.class.getResource(String.valueOf(Combo_Styles.class.getSimpleName()) + ".xwt");
        this.runTest(url, prepare, checker);
    }
}

