/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.util;

import org.eclipse.core.internal.resources.semantic.ui.util.Messages;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SFSBrowserTreeLabelProvider
implements ITableLabelProvider {
    private static final Image FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private static final Image NONEXIST = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED");

    public void configureTreeColumns(final TreeViewer tv) {
        final Tree tree = tv.getTree();
        TreeColumn c1 = new TreeColumn(tree, 0);
        c1.setWidth(450);
        c1.setText(Messages.SFSBrowserTreeLabelProvider_Name_XCOL);
        tree.setHeaderVisible(true);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                boolean expanded = tv.getExpandedState(item.getData());
                if (expanded) {
                    tv.collapseToLevel(item.getData(), 1);
                } else {
                    tv.expandToLevel(item.getData(), 1);
                }
            }
        });
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            SFSBrowserTreeObject obj = (SFSBrowserTreeObject)element;
            if (!obj.getInfo().exists()) {
                return NONEXIST;
            }
            if (obj.getInfo().isDirectory()) {
                return FOLDER;
            }
            return FILE;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SFSBrowserTreeObject object = (SFSBrowserTreeObject)element;
        if (columnIndex == 0) {
            return object.getPath().lastSegment();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

