/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserPropertiesContentProvider;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserPropertiesLabelProvider;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeContentProvider;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeLabelProvider;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.osgi.framework.Bundle;

public class SemanticResourcesView
extends ViewPart {
    String selectedPath;
    boolean autoRefresh = false;
    Job scheduledJob;
    TreeViewer sfsTree;
    Button existsBox;
    Text timestampText;
    TreeViewer propsTable;
    static final int REFRESH_RATE = 5000;
    final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss::SSS");

    public void createPartControl(Composite parent) {
        SFSBrowserTreeObject[] input;
        Composite main = new Composite(parent, 0);
        ToolBar tb = this.getViewSite() == null ? new ToolBar(main, 0x4000100) : null;
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        try {
            input = this.getRootObjects();
        }
        catch (CoreException e) {
            Label errorLabel = new Label(main, 0);
            errorLabel.setText(e.getStatus().getMessage());
            return;
        }
        final Label pathLabel = new Label(main, 0);
        GridDataFactory.fillDefaults().exclude(true).align(16384, 0x1000000).applyTo((Control)pathLabel);
        pathLabel.setText(Messages.SemanticResourcesView_Path_XFLD);
        final Text path = new Text(main, 2056);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).align(4, 0x1000000).applyTo((Control)path);
        final SashForm sf = new SashForm(main, 256);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)sf);
        this.sfsTree = new TreeViewer((Composite)sf);
        SFSBrowserTreeLabelProvider treeLabelProvider = new SFSBrowserTreeLabelProvider();
        treeLabelProvider.configureTreeColumns(this.sfsTree);
        this.sfsTree.setContentProvider((IContentProvider)new SFSBrowserTreeContentProvider());
        this.sfsTree.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.sfsTree.getTree());
        final Group propsMain = new Group((Composite)sf, 16);
        sf.setMaximizedControl((Control)this.sfsTree.getTree());
        propsMain.setLayout((Layout)new GridLayout(2, false));
        this.existsBox = new Button((Composite)propsMain, 32);
        this.existsBox.setText(Messages.SemanticResourcesView_Exists_XFLD);
        this.existsBox.setEnabled(false);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.existsBox);
        Label timestampLabel = new Label((Composite)propsMain, 0);
        timestampLabel.setText(Messages.SemanticResourcesView_Timestamp_XFLD);
        this.timestampText = new Text((Composite)propsMain, 2048);
        this.timestampText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.timestampText);
        this.propsTable = new TreeViewer((Composite)propsMain);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.propsTable.getTree());
        SFSBrowserPropertiesLabelProvider labelProvider = new SFSBrowserPropertiesLabelProvider();
        labelProvider.configureTreeColumns(this.propsTable);
        this.propsTable.setContentProvider((IContentProvider)new SFSBrowserPropertiesContentProvider());
        this.propsTable.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (tb == null) {
            IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
            Action refresh = new Action(Messages.BrowseSFSDialog_Refresh_XBUT, 1){

                public void run() {
                    SemanticResourcesView.this.scheduleRefresh(0L);
                }
            };
            mgr.add((IAction)refresh);
            Action autoRefreshAction = new Action(Messages.SemanticResourcesView_AutoRefresh_XCKL, 2){

                public void run() {
                    SemanticResourcesView.this.autoRefresh = this.isChecked();
                    if (this.isChecked()) {
                        SemanticResourcesView.this.scheduleRefresh(0L);
                    }
                }
            };
            ActionContributionItem it = new ActionContributionItem((IAction)autoRefreshAction);
            mgr.add((IContributionItem)it);
            mgr.update(false);
            ToolItem autoRefreshItem = (ToolItem)it.getWidget();
            autoRefreshItem.setToolTipText(MessageFormat.format(Messages.SemanticResourcesView_RefreshRate_XTOL, new Integer(5000)));
        } else {
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)tb);
            ToolItem refresh = new ToolItem(tb, 8);
            refresh.setText(Messages.BrowseSFSDialog_Refresh_XBUT);
            refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    SemanticResourcesView.this.scheduleRefresh(0L);
                }
            });
        }
        this.sfsTree.setInput((Object)input);
        if (this.selectedPath != null && !this.selectedPath.equals("")) {
            try {
                SFSBrowserTreeObject object = this.getTreeObject(this.selectedPath);
                this.sfsTree.setSelection((ISelection)new StructuredSelection((Object)object));
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.ui.resources.semantic")).log(e.getStatus());
            }
        }
        this.sfsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    path.setText("");
                    SemanticResourcesView.this.selectedPath = null;
                    propsMain.setText("");
                    SemanticResourcesView.this.propsTable.setInput(null);
                    SemanticResourcesView.this.existsBox.setSelection(false);
                    SemanticResourcesView.this.timestampText.setText("");
                    sf.setMaximizedControl((Control)SemanticResourcesView.this.sfsTree.getTree());
                } else {
                    SFSBrowserTreeObject selected = (SFSBrowserTreeObject)sel.getFirstElement();
                    SemanticResourcesView.this.selectedPath = selected.getPath().toString();
                    path.setText(SemanticResourcesView.this.selectedPath);
                    propsMain.setText(MessageFormat.format(Messages.SemanticResourcesView_PropertiesOf_XGRP, selected.getInfo().getName()));
                    SemanticResourcesView.this.existsBox.setSelection(selected.getInfo().exists());
                    SemanticResourcesView.this.timestampText.setText(SemanticResourcesView.this.df.format(new Date(selected.getInfo().getLastModified())));
                    SemanticResourcesView.this.propsTable.setInput((Object)selected);
                    SemanticResourcesView.this.propsTable.expandAll();
                    sf.setMaximizedControl(null);
                }
                path.setVisible(!sel.isEmpty());
                pathLabel.setVisible(!sel.isEmpty());
                GridData gd = (GridData)path.getLayoutData();
                gd.exclude = sel.isEmpty();
                gd = (GridData)pathLabel.getLayoutData();
                gd.exclude = sel.isEmpty();
                path.getParent().layout(true);
            }
        });
    }

    public void setFocus() {
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(String path) {
        this.selectedPath = path;
    }

    public void dispose() {
        if (this.scheduledJob != null) {
            this.scheduledJob.cancel();
            this.scheduledJob = null;
        }
        super.dispose();
    }

    void refreshInternal() throws CoreException {
        final SFSBrowserTreeObject[] newInput = this.getRootObjects();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object[] expandedObjects = SemanticResourcesView.this.sfsTree.getExpandedElements();
                SemanticResourcesView.this.sfsTree.setInput((Object)newInput);
                SemanticResourcesView.this.sfsTree.setExpandedElements(expandedObjects);
                if (SemanticResourcesView.this.selectedPath != null) {
                    SFSBrowserTreeObject selected = (SFSBrowserTreeObject)SemanticResourcesView.this.propsTable.getInput();
                    SemanticResourcesView.this.propsTable.refresh();
                    SemanticResourcesView.this.propsTable.expandAll();
                    if (selected != null) {
                        SemanticResourcesView.this.existsBox.setSelection(selected.getInfo().exists());
                        SemanticResourcesView.this.timestampText.setText(SemanticResourcesView.this.df.format(new Date(selected.getInfo().getLastModified())));
                    }
                } else {
                    SemanticResourcesView.this.propsTable.setInput(null);
                    SemanticResourcesView.this.existsBox.setSelection(false);
                    SemanticResourcesView.this.timestampText.setText("");
                }
            }
        });
        if (this.autoRefresh) {
            this.scheduleRefresh(5000L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void scheduleRefresh(long delay) {
        if (this.getSite() == null) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            SemanticResourcesView.this.refreshInternal();
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                return;
            }
            catch (InvocationTargetException e1) {
                Throwable cause = e1.getCause();
                if (!(cause instanceof CoreException)) return;
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.ui.resources.semantic")).log(((CoreException)cause).getStatus());
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        } else {
            Job refreshJob = new Job(Messages.SemanticResourcesView_RefreshJob_XGRP){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        SemanticResourcesView.this.refreshInternal();
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return new Status(0, "org.eclipse.ui.resources.semantic", "");
                }
            };
            refreshJob.setSystem(true);
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
            this.scheduledJob = refreshJob;
            service.schedule(refreshJob, delay);
        }
    }

    SFSBrowserTreeObject[] getRootObjects() throws CoreException {
        ISemanticFileSystem fs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
        String[] roots = fs.getRootNames();
        SFSBrowserTreeObject[] paths = new SFSBrowserTreeObject[roots.length];
        int i = 0;
        while (i < roots.length) {
            Path path = new Path(String.valueOf('/') + roots[i]);
            paths[i] = new SFSBrowserTreeObject((IFileSystem)fs, (IPath)path);
            ++i;
        }
        return paths;
    }

    SFSBrowserTreeObject getTreeObject(String path) throws CoreException {
        IFileSystem fs = EFS.getFileSystem((String)"semanticfs");
        return new SFSBrowserTreeObject(fs, (IPath)new Path(path));
    }
}

