/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;

public class MMenuItemTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            this.appContext.dispose();
        }
    }

    private void testMMenuItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setLabel(before);
        window.setMainMenu(menu);
        menu.getChildren().add(menuItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget);
        MMenuItemTest.assertTrue((boolean)(widget instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget;
        MMenuItemTest.assertEquals((String)beforeExpected, (String)menuItemWidget.getText());
        menuItem.setLabel(after);
        MMenuItemTest.assertEquals((String)afterExpected, (String)menuItemWidget.getText());
    }

    public void testMMenuItem_Text_NullNull() {
        this.testMMenuItem_Text(null, "", null, "");
    }

    public void testMMenuItem_Text_NullEmpty() {
        this.testMMenuItem_Text(null, "", "", "");
    }

    public void testMMenuItem_Text_NullString() {
        this.testMMenuItem_Text(null, "", "label", "label");
    }

    public void testMMenuItem_Text_EmptyNull() {
        this.testMMenuItem_Text("", "", null, "");
    }

    public void testMMenuItem_Text_EmptyEmpty() {
        this.testMMenuItem_Text("", "", "", "");
    }

    public void testMMenuItem_Text_EmptyString() {
        this.testMMenuItem_Text("", "", "label", "label");
    }

    public void testMMenuItem_Text_StringNull() {
        this.testMMenuItem_Text("label", "label", null, "");
    }

    public void testMMenuItem_Text_StringEmpty() {
        this.testMMenuItem_Text("label", "label", "", "");
    }

    public void testMMenuItem_Text_StringStringUnchanged() {
        this.testMMenuItem_Text("label", "label", "label", "label");
    }

    public void testMMenuItem_Text_StringStringChanged() {
        this.testMMenuItem_Text("label", "label", "label2", "label2");
    }

    public void testMMenuItem_RadioItems() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        MDirectMenuItem menuItem2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem1.setType(ItemType.RADIO);
        menuItem2.setType(ItemType.RADIO);
        menu.getChildren().add(menuItem1);
        menu.getChildren().add(menuItem2);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget1 = menuItem1.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        Object widget2 = menuItem2.getWidget();
        MMenuItemTest.assertNotNull((Object)widget2);
        MMenuItemTest.assertTrue((boolean)(widget2 instanceof MenuItem));
        MenuItem menuItemWidget1 = (MenuItem)widget1;
        MenuItem menuItemWidget2 = (MenuItem)widget2;
        menuItemWidget1.setSelection(false);
        menuItemWidget2.setSelection(true);
        menuItemWidget1.notifyListeners(13, new Event());
        menuItemWidget2.notifyListeners(13, new Event());
        MMenuItemTest.assertFalse((boolean)menuItem1.isSelected());
        MMenuItemTest.assertTrue((boolean)menuItem2.isSelected());
        menuItemWidget2.setSelection(false);
        menuItemWidget1.setSelection(true);
        menuItemWidget2.notifyListeners(13, new Event());
        menuItemWidget1.notifyListeners(13, new Event());
        MMenuItemTest.assertTrue((boolean)menuItem1.isSelected());
        MMenuItemTest.assertFalse((boolean)menuItem2.isSelected());
        menuItem1.setSelected(false);
        MMenuItemTest.assertFalse((boolean)menuItemWidget1.getSelection());
        menuItem2.setSelected(true);
        MMenuItemTest.assertTrue((boolean)menuItemWidget2.getSelection());
    }

    public void testMDirectMenuItem_Check_Bug316752() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget1 = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        MMenuItemTest.assertTrue((boolean)menuItemWidget.getSelection());
    }

    public void testMHandledMenuItem_Check_Bug316752() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        command.setElementId("commandId");
        menuItem.setCommand(command);
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget1 = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        MMenuItemTest.assertTrue((boolean)menuItemWidget.getSelection());
    }
}

