/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public abstract class ModelResourceTest
extends TestCase {
    private File temporaryFile;
    private URI temporaryURI;
    private Resource.Factory factory;
    private Resource resource;
    private XMLResource xmlResource;

    protected void setUp() throws Exception {
        this.temporaryFile = new File(System.getProperty("java.io.tmpdir"), String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + ".e4xmi");
        this.temporaryFile.delete();
        this.temporaryURI = URI.createFileURI((String)this.temporaryFile.getAbsolutePath());
        this.factory = this.createFactory();
        ModelResourceTest.assertNotNull((Object)this.factory);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
        this.temporaryFile.delete();
        this.temporaryFile = null;
        this.temporaryURI = null;
    }

    protected String getId(MApplicationElement applicationElement) {
        return this.getId((EObject)applicationElement);
    }

    protected String getId(EObject object) {
        return this.xmlResource.getID(object);
    }

    protected Resource.Factory createFactory() {
        return new E4XMIResourceFactory();
    }

    protected void saveModel() {
        try {
            this.resource.save(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected MApplication createApplication() {
        this.resource = this.factory.createResource(this.temporaryURI);
        if (this.resource instanceof XMLResource) {
            this.xmlResource = (XMLResource)this.resource;
        }
        if (this.temporaryFile.exists()) {
            try {
                this.resource.load(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return (MApplication)this.resource.getContents().get(0);
        }
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        this.resource.getContents().add((Object)((EObject)application));
        return application;
    }

    protected MWindow createWindow(MApplication application) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        return window;
    }

    protected MTrimmedWindow createTrimmedWindow(MApplication application) {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        application.getChildren().add(window);
        return window;
    }
}

