/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerTrimContainerTest
extends ModelReconcilerTest {
    private void testTrimContainer_Side(SideValue applicationState, SideValue userChange, SideValue newApplicationState) {
        MApplication application = this.createApplication();
        MTrimmedWindow window = this.createTrimmedWindow(application);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        trimBar.setSide(applicationState);
        window.getTrimBars().add(trimBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        trimBar.setSide(userChange);
        Object serialize = reconciler.serialize();
        application = this.createApplication();
        window = (MTrimmedWindow)application.getChildren().get(0);
        trimBar = (MTrimBar)window.getTrimBars().get(0);
        trimBar.setSide(newApplicationState);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serialize);
        ModelReconcilerTrimContainerTest.assertEquals((Object)newApplicationState, (Object)trimBar.getSide());
        this.applyAll(deltas);
        if (userChange == applicationState) {
            ModelReconcilerTrimContainerTest.assertEquals((Object)newApplicationState, (Object)trimBar.getSide());
        } else {
            ModelReconcilerTrimContainerTest.assertEquals((Object)userChange, (Object)trimBar.getSide());
        }
    }

    public void testTrimContainer_Side_TopTopTop() {
        this.testTrimContainer_Side(SideValue.TOP, SideValue.TOP, SideValue.TOP);
    }

    public void testTrimContainer_Side_TopTopRight() {
        this.testTrimContainer_Side(SideValue.TOP, SideValue.TOP, SideValue.RIGHT);
    }

    public void testTrimContainer_Side_TopRightTop() {
        this.testTrimContainer_Side(SideValue.TOP, SideValue.RIGHT, SideValue.TOP);
    }

    public void testTrimContainer_Side_TopRightRight() {
        this.testTrimContainer_Side(SideValue.TOP, SideValue.RIGHT, SideValue.RIGHT);
    }

    public void testTrimContainer_Side_RightTopTop() {
        this.testTrimContainer_Side(SideValue.RIGHT, SideValue.TOP, SideValue.TOP);
    }

    public void testTrimContainer_Side_RightTopRight() {
        this.testTrimContainer_Side(SideValue.RIGHT, SideValue.TOP, SideValue.RIGHT);
    }

    public void testTrimContainer_Side_RightRightTop() {
        this.testTrimContainer_Side(SideValue.RIGHT, SideValue.RIGHT, SideValue.TOP);
    }

    public void testTrimContainer_Side_RightRightRight() {
        this.testTrimContainer_Side(SideValue.RIGHT, SideValue.RIGHT, SideValue.RIGHT);
    }

    public void testTrimContainer_Side_RightRightBottom() {
        this.testTrimContainer_Side(SideValue.RIGHT, SideValue.RIGHT, SideValue.BOTTOM);
    }

    public void testTrimContainer_Side_RightBottomRight() {
        this.testTrimContainer_Side(SideValue.RIGHT, SideValue.BOTTOM, SideValue.RIGHT);
    }

    public void testTrimContainer_Side_BottomRightRight() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.RIGHT, SideValue.RIGHT);
    }

    public void testTrimContainer_Side_BottomRightBottom() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.RIGHT, SideValue.BOTTOM);
    }

    public void testTrimContainer_Side_BottomBottomRight() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.BOTTOM, SideValue.TOP);
    }

    public void testTrimContainer_Side_BottomBottomBottom() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.BOTTOM, SideValue.BOTTOM);
    }

    public void testTrimContainer_Side_BottomBottomLeft() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.BOTTOM, SideValue.LEFT);
    }

    public void testTrimContainer_Side_BottomLeftBottom() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.LEFT, SideValue.BOTTOM);
    }

    public void testTrimContainer_Side_BottomLeftLeft() {
        this.testTrimContainer_Side(SideValue.BOTTOM, SideValue.LEFT, SideValue.LEFT);
    }

    public void testTrimContainer_Side_LeftBottomBottom() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.BOTTOM, SideValue.BOTTOM);
    }

    public void testTrimContainer_Side_LeftBottomLeft() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.BOTTOM, SideValue.LEFT);
    }

    public void testTrimContainer_Side_LeftLeftBottom() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.LEFT, SideValue.BOTTOM);
    }

    public void testTrimContainer_Side_LeftLeftLeft() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.LEFT, SideValue.LEFT);
    }

    public void testTrimContainer_Side_LeftLeftTop() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.LEFT, SideValue.TOP);
    }

    public void testTrimContainer_Side_LeftTopLeft() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.TOP, SideValue.LEFT);
    }

    public void testTrimContainer_Side_LeftTopTop() {
        this.testTrimContainer_Side(SideValue.LEFT, SideValue.TOP, SideValue.TOP);
    }
}

