/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerBindingTableTest
extends ModelReconcilerTest {
    private void testBindingTable_BindingContextId(String before, String after) {
        MApplication application = this.createApplication();
        MBindingTable bindingTable = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        bindingTable.setBindingContextId(before);
        application.getBindingTables().add(bindingTable);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        bindingTable.setBindingContextId(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        bindingTable = (MBindingTable)application.getBindingTables().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerBindingTableTest.assertEquals((String)before, (String)bindingTable.getBindingContextId());
        this.applyAll(deltas);
        ModelReconcilerBindingTableTest.assertEquals((String)after, (String)bindingTable.getBindingContextId());
    }

    public void testBindingTable_BindingContextId_NullNull() {
        this.testBindingTable_BindingContextId(null, null);
    }

    public void testBindingTable_BindingContextId_NullEmpty() {
        this.testBindingTable_BindingContextId(null, "");
    }

    public void testBindingTable_BindingContextId_NullString() {
        this.testBindingTable_BindingContextId(null, "name");
    }

    public void testBindingTable_BindingContextId_EmptyNull() {
        this.testBindingTable_BindingContextId("", null);
    }

    public void testBindingTable_BindingContextId_EmptyEmpty() {
        this.testBindingTable_BindingContextId("", "");
    }

    public void testBindingTable_BindingContextId_EmptyString() {
        this.testBindingTable_BindingContextId("", "name");
    }

    public void testBindingTable_BindingContextId_StringNull() {
        this.testBindingTable_BindingContextId("name", null);
    }

    public void testBindingTable_BindingContextId_StringEmpty() {
        this.testBindingTable_BindingContextId("name", "");
    }

    public void testBindingTable_BindingContextId_StringStringUnchanged() {
        this.testBindingTable_BindingContextId("name", "name");
    }

    public void testBindingTable_BindingContextId_StringStringChanged() {
        this.testBindingTable_BindingContextId("name", "name2");
    }
}

