/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import org.eclipse.core.resources.semantic.examples.remote.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class RemoteItem {
    protected final RemoteStoreTransient myStore;
    protected final RemoteFolder myParent;
    private final IPath myPath;
    private final Type myType;
    private final String myName;
    private boolean lockFlag;

    public RemoteItem(RemoteStoreTransient store, RemoteFolder parent, String name, Type type) {
        if (parent != null && parent.getType() != Type.FOLDER) {
            throw new IllegalArgumentException(Messages.RemoteItem_ItemsUnderFolderOrRoot_XMSG);
        }
        this.myParent = parent;
        this.myStore = store;
        this.myType = type;
        this.myName = name;
        this.lockFlag = false;
        this.myPath = parent != null ? parent.getPath().append(name) : new Path("");
    }

    public Type getType() {
        return this.myType;
    }

    public String getName() {
        return this.myName;
    }

    public IPath getPath() {
        return this.myPath;
    }

    public boolean isLocked() {
        return this.lockFlag;
    }

    public void setLocked(boolean lockFlag) {
        this.lockFlag = lockFlag;
    }

    public RemoteStoreTransient getStore() {
        return this.myStore;
    }

    public RemoteFolder getParent() {
        return this.myParent;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.myPath == null ? 0 : this.myPath.hashCode());
        result = 31 * result + (this.myStore == null ? 0 : this.myStore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteItem other = (RemoteItem)obj;
        if (this.myPath == null ? other.myPath != null : !this.myPath.equals((Object)other.myPath)) {
            return false;
        }
        return !(this.myStore == null ? other.myStore != null : !this.myStore.equals(other.myStore));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        FOLDER;

    }
}

