/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.Messages;
import org.eclipse.core.resources.semantic.examples.providers.RESTUtil;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderREST;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SampleRESTReadonlyContentProvider
extends CachingContentProvider
implements ISemanticContentProviderREST {
    public ICacheServiceFactory getCacheServiceFactory() throws CoreException {
        return new FileCacheServiceFactory();
    }

    public InputStream openInputStreamInternal(final ISemanticFileStore store, IProgressMonitor monitor, final CachingContentProvider.ICacheTimestampSetter timeStampSetter) throws CoreException {
        String remoteURI = this.getURIStringInternal(store);
        if (remoteURI == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, store.getPath(), NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_RemoteUriNotSet_XMSG, (Object)store.getPath().toString()));
        }
        try {
            return RESTUtil.openInputStream(remoteURI, new RESTUtil.IRESTCallback(){

                public void setTimestamp(long timestamp) {
                    timeStampSetter.setTimestamp(timestamp);
                }

                public void setContentType(String contentType) {
                    try {
                        SampleRESTReadonlyContentProvider.this.setContentTypeInternal(store, contentType);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, store.getPath(), e.getMessage(), (Throwable)e);
        }
    }

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        switch (resourceType) {
            case FOLDER_TYPE: {
                parentStore.addChildFolder(name);
                break;
            }
            default: {
                throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, parentStore.getPath(), Messages.SampleRESTReadonlyContentProvider_MethodNotSupported_XMSG);
            }
        }
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        String uriString = SemanticSpiResourceInfo.isOptionRequested((int)64, (int)options) ? this.getURIStringInternal(semanticFileStore) : null;
        boolean existsRemotely = false;
        if (SemanticSpiResourceInfo.isOptionRequested((int)32, (int)options)) {
            String remoteURI = this.getURIString(semanticFileStore);
            if (remoteURI == null) {
                throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, semanticFileStore.getPath(), NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_RemoteUriNotSet_XMSG, (Object)semanticFileStore.getPath().toString()));
            }
            try {
                InputStream is = RESTUtil.openInputStream(remoteURI, null);
                existsRemotely = is != null;
                Util.safeClose((InputStream)is);
            }
            catch (IOException iOException) {}
        }
        return new SemanticSpiResourceInfo(options, false, false, true, existsRemotely, uriString, this.getContentTypeInternal(semanticFileStore));
    }

    public void removeResource(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        this.deleteCache(semanticFileStore, monitor);
        semanticFileStore.remove(monitor);
    }

    public void revertChanges(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
    }

    public void setReadOnly(ISemanticFileStore childStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        this.setReadOnlyInternal(childStore, readonly);
    }

    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        if (semanticFileStore.getType() == 1) {
            if (semanticFileStore.isLocalOnly()) {
                return;
            }
            if (direction == SyncDirection.INCOMING || direction == SyncDirection.BOTH) {
                this.dropCache(semanticFileStore, monitor, this.deleteAllVisitor, status);
                this.fillCache(semanticFileStore, monitor, status);
            }
        } else {
            IFileStore[] childStores;
            try {
                childStores = semanticFileStore.childStores(0, monitor);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            IFileStore[] iFileStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                if (store instanceof ISemanticFileStore) {
                    this.synchronizeContentWithRemote((ISemanticFileStore)store, direction, monitor, status);
                }
                ++n2;
            }
        }
    }

    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        return new Status(8, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null);
    }

    public IStatus validateSave(ISemanticFileStore semanticFileStore) {
        return new Status(8, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null);
    }

    public void addFileFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        parentStore.addChildFile(name);
        ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
        this.setURIStringInternal(newChild, uri.toString());
        this.setReadOnly(newChild, true, monitor);
    }

    public void addFolderFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, parentStore.getPath(), Messages.SampleRESTReadonlyContentProvider_MethodNotSupported_XMSG);
    }

    public String getURIString(ISemanticFileStore semanticFileStore) throws CoreException {
        return this.getURIStringInternal(semanticFileStore);
    }

    public void setURIString(ISemanticFileStore semanticFileStore, URI uri, IProgressMonitor monitor) throws CoreException {
        this.setURIStringInternal(semanticFileStore, uri.toString());
        if (semanticFileStore.getType() == 1) {
            this.deleteCache(semanticFileStore, monitor);
            MultiStatus status = new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_MethodResult_XMSG, (Object)"setURISting"), null);
            this.fillCache(semanticFileStore, monitor, status);
            if (!status.isOK()) {
                throw new CoreException((IStatus)status);
            }
        }
    }
}

