/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.properties.tabbed.sections;

import java.util.List;
import java.util.Map;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ChangeLayoutCommand;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.pages.AssistancePageFactory;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.pages.IAssistantPage;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.properties.tabbed.sections.AbstractAttributeSection;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class LayoutSection
extends AbstractAttributeSection {
    private CCombo layoutCombo;
    private Composite layoutPage;
    private StackLayout pageLayout;
    private Label noneInfoLable;
    private Map<Object, IAssistantPage> pages = AssistancePageFactory.newPages();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this._createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.getWidgetFactory().createLabel(composite, "Type:");
        Control control = this.createSection(composite);
        control.setLayoutData((Object)new GridData(768));
        this.createClearButton(composite);
        ExpandableComposite expandable = this.getWidgetFactory().createExpandableComposite(composite, 66);
        expandable.setText("Values");
        expandable.setExpanded(true);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        expandable.setLayoutData((Object)layoutData);
        ToolBar toolBar = new ToolBar((Composite)expandable, 0x800000);
        toolBar.setBackground(parent.getDisplay().getSystemColor(1));
        ToolItem clearAction = new ToolItem(toolBar, 8);
        clearAction.setImage(ImageShop.get("/icons/full/tools/clear_filter.gif"));
        clearAction.setToolTipText("Clear setting values.");
        clearAction.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LayoutSection.this.clearValues();
            }
        });
        expandable.setTextClient((Control)toolBar);
        this.layoutPage = this.getWidgetFactory().createComposite((Composite)expandable);
        expandable.setClient((Control)this.layoutPage);
        this.pageLayout = new StackLayout();
        this.layoutPage.setLayout((Layout)this.pageLayout);
        this.noneInfoLable = this.getWidgetFactory().createLabel(this.layoutPage, "There is no layout values.", 0x1000080);
    }

    protected void clearValues() {
        Object data = this.pageLayout.topControl.getData();
        if (data instanceof IAssistantPage) {
            ((IAssistantPage)data).performDefault();
        }
    }

    protected Control createSection(Composite parent) {
        this.layoutCombo = this.getWidgetFactory().createCCombo(parent, 8);
        List<LayoutType> layoutsList = LayoutsHelper.layoutsList;
        String[] items = new String[layoutsList.size()];
        int i = 0;
        while (i < layoutsList.size()) {
            items[i] = layoutsList.get(i).value();
            ++i;
        }
        this.layoutCombo.setItems(items);
        this.layoutCombo.addListener(13, (Listener)this);
        return this.layoutCombo;
    }

    protected String getAttributeName() {
        return "layout";
    }

    public void doRefresh() {
        if (this.layoutCombo == null || this.layoutCombo.isDisposed()) {
            return;
        }
        LayoutType layoutType = LayoutsHelper.getLayoutType((EditPart)this.getEditPart());
        int index = this.layoutCombo.indexOf(layoutType.value());
        if (index >= 0 && index != this.layoutCombo.getSelectionIndex()) {
            this.layoutCombo.removeListener(13, (Listener)this);
            this.layoutCombo.select(index);
            this.refreshLayoutPage(layoutType);
            this.layoutCombo.addListener(13, (Listener)this);
        }
    }

    private void refreshLayoutPage(LayoutType layoutType) {
        if (this.layoutPage == null || this.layoutPage.isDisposed()) {
            return;
        }
        WidgetEditPart editPart = this.getEditPart();
        IAssistantPage page = this.pages.get((Object)layoutType);
        if (page != null) {
            this.pageLayout.topControl = page.getControl(this.layoutPage);
            page.setEditPart((EditPart)editPart);
        } else {
            this.pageLayout.topControl = this.noneInfoLable;
        }
        this.layoutPage.layout();
    }

    public void handleEvent(Event event) {
        WidgetEditPart editPart = this.getEditPart();
        if (editPart != null && event.widget == this.layoutCombo) {
            String item = this.layoutCombo.getItem(this.layoutCombo.getSelectionIndex());
            LayoutType layoutType = LayoutsHelper.getLayoutType(item);
            this.executeCommand(new ChangeLayoutCommand((EditPart)editPart, layoutType));
            this.refreshLayoutPage(layoutType);
        }
    }

    protected String getNewValue(Event event) {
        return null;
    }
}

