/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.feedback;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;

public class FeedbackManager {
    private GraphicalEditPolicy policy;
    private final Map<Request, IFigure> req2feedback = new HashMap<Request, IFigure>(1);

    public FeedbackManager(GraphicalEditPolicy policy) {
        this.policy = policy;
    }

    public synchronized void addFeedback(Request req, IFigure feedback) {
        if (this.req2feedback.containsKey(req)) {
            return;
        }
        this.req2feedback.put(req, feedback);
        IFigure feedbackLayer = this.getFeedbackLayer();
        if (feedbackLayer != null && feedback != null) {
            feedbackLayer.add(feedback);
        }
    }

    public synchronized boolean contains(Request req) {
        return this.req2feedback.containsKey(req);
    }

    public IFigure getFeedbackLayer() {
        return LayerManager.Helper.find((EditPart)this.policy.getHost()).getLayer((Object)"Feedback Layer");
    }

    public synchronized IFigure eraseFeedback(Request req) {
        IFigure feedback = this.req2feedback.remove(req);
        IFigure feedbackLayer = this.getFeedbackLayer();
        if (feedbackLayer != null && feedback != null) {
            feedbackLayer.remove(feedback);
        }
        return feedback;
    }

    public EditPart getHost() {
        return this.policy.getHost();
    }

    public IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }
}

