/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.util.swt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.e4.xwt.tools.ui.designer.core.DesignerPlugin;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.SWTUtil;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SWTWorkarounds {
    static final Rectangle EMPTY = new Rectangle(0, 0, 0, 0);

    public static Rectangle getBounds(Object object) {
        if (SWTUtil.IsWindows) {
            if (object instanceof TabItem) {
                return SWTWorkarounds.win32_getBounds((TabItem)object);
            }
            if (object instanceof TableColumn) {
                return SWTWorkarounds.win32_getBounds((TableColumn)object);
            }
            if (object instanceof TreeColumn) {
                return SWTWorkarounds.win32_getBounds((TreeColumn)object);
            }
        }
        if (SWTUtil.IsGTK) {
            if (object instanceof TabItem) {
                return SWTWorkarounds.gtk_getBounds((TabItem)object);
            }
            if (object instanceof TableColumn) {
                return SWTWorkarounds.gtk_getBounds((TableColumn)object);
            }
            if (object instanceof TreeColumn) {
                return SWTWorkarounds.gtk_getBounds((TreeColumn)object);
            }
        }
        if (SWTUtil.IsMotif) {
            if (object instanceof TabItem) {
                return SWTWorkarounds.motif_getBounds((TabItem)object);
            }
            if (object instanceof TableColumn) {
                return SWTWorkarounds.motif_getBounds((TableColumn)object);
            }
            if (object instanceof TreeColumn) {
                return SWTWorkarounds.motif_getBounds((TreeColumn)object);
            }
        }
        if (SWTUtil.IsCarbon) {
            if (object instanceof TabItem) {
                return SWTWorkarounds.carbon_getBounds((TabItem)object);
            }
            if (object instanceof TableColumn) {
                return SWTWorkarounds.carbon_getBounds((TableColumn)object);
            }
            if (object instanceof TreeColumn) {
                return SWTWorkarounds.carbon_getBounds((TreeColumn)object);
            }
            if (object instanceof Menu || object instanceof MenuItem) {
                return EMPTY;
            }
        }
        if (SWTUtil.IsCocoa) {
            if (object instanceof TabItem) {
                return SWTWorkarounds.cocoa_getBounds((TabItem)object);
            }
            if (object instanceof TableColumn) {
                return SWTWorkarounds.cocoa_getBounds((TableColumn)object);
            }
            if (object instanceof TreeColumn) {
                return SWTWorkarounds.cocoa_getBounds((TreeColumn)object);
            }
            if (object instanceof Menu || object instanceof MenuItem) {
                return EMPTY;
            }
        }
        try {
            Method method = object.getClass().getDeclaredMethod("getBounds", new Class[0]);
            method.setAccessible(true);
            return (Rectangle)method.invoke(object, new Object[0]);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static Rectangle getBounds(MenuItem menuItem) {
        Rectangle itemRect = SWTWorkarounds.getBounds((Object)menuItem);
        Rectangle menuRect = SWTWorkarounds.getBounds(menuItem.getParent());
        itemRect.x = (menuItem.getParent().getStyle() & 0x4000000) != 0 ? menuRect.x + menuRect.width - itemRect.width - itemRect.x : (itemRect.x += menuRect.x);
        itemRect.y += menuRect.y;
        return itemRect;
    }

    public static Rectangle getBounds(Menu menu) {
        Rectangle result = SWTWorkarounds.getBounds((Object)menu);
        Decorations parent = menu.getParent();
        if (parent == null || parent.isDisposed()) {
            return result;
        }
        Rectangle bounds = parent.getBounds();
        if (!result.isEmpty() && parent != null) {
            return new Rectangle(result.x - bounds.x, result.y - bounds.y, result.width, result.height);
        }
        if (SWTTools.checkStyle((Widget)menu, 2)) {
            if (menu.getItemCount() == 0) {
                Point offset = SWTTools.getOffset((Scrollable)parent);
                return new Rectangle(offset.x, offset.y - 19, bounds.width - offset.x * 2, 1);
            }
            int y = SWTTools.getOffset((Scrollable)parent).y;
            int x = SWTTools.getOffset((Scrollable)parent).x;
            return new Rectangle(x, y - 19, bounds.width - x * 2, 19);
        }
        return result;
    }

    public static Rectangle getBounds(ScrollBar bar) {
        int y;
        int x;
        Scrollable parent = bar.getParent();
        Point parentSize = parent.getSize();
        Point size = bar.getSize();
        if ((bar.getStyle() & 0x100) != 0) {
            x = 0;
            y = parentSize.y - size.y;
        } else {
            x = parentSize.x - size.x;
            y = 0;
        }
        return bar.getDisplay().map((Control)parent, null, x, y, size.x, size.y);
    }

    static int SendMessage(int hWnd, int Msg, int wParam, int[] lParam) {
        int result = 0;
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.win32.OS");
            Class[] params = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, lParam.getClass()};
            Method method = clazz.getMethod("SendMessage", params);
            Object[] args = new Object[]{hWnd, Msg, wParam, lParam};
            result = (Integer)method.invoke(clazz, args);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return result;
    }

    static Rectangle win32_getBounds(TabItem tabItem) {
        TabFolder parent = tabItem.getParent();
        int index = parent.indexOf(tabItem);
        if (index != -1) {
            int[] rect = new int[4];
            try {
                Field field = parent.getClass().getField("handle");
                SWTWorkarounds.SendMessage(field.getInt(parent), 4874, index, rect);
                int width = rect[2] - rect[0];
                int height = rect[3] - rect[1];
                Rectangle bounds = new Rectangle(rect[0], rect[1], width, height);
                return bounds;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    static Rectangle win32_getBounds(TableColumn tableColumn) {
        Table parent = tableColumn.getParent();
        int index = parent.indexOf(tableColumn);
        if (index != -1) {
            try {
                Field field = parent.getClass().getField("handle");
                int hwndHeader = SWTWorkarounds.SendMessage(field.getInt(parent), 4127, 0, new int[0]);
                int[] rect = new int[4];
                SWTWorkarounds.SendMessage(hwndHeader, 4615, index, rect);
                int width = rect[2] - rect[0];
                int height = rect[3] - rect[1];
                Rectangle bounds = new Rectangle(rect[0], rect[1], width, height);
                return bounds;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    static Rectangle win32_getBounds(TreeColumn treeColumn) {
        Tree parent = treeColumn.getParent();
        int index = parent.indexOf(treeColumn);
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwndHeader = 0;
        try {
            Field getHeaderField = parent.getClass().getDeclaredField("hwndHeader");
            getHeaderField.setAccessible(true);
            hwndHeader = (Integer)getHeaderField.get(parent);
        }
        catch (Exception e) {
            DesignerPlugin.logInfo(e);
        }
        if (hwndHeader == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] rect = new int[4];
        SWTWorkarounds.SendMessage(hwndHeader, 4615, index, rect);
        int width = rect[2] - rect[0];
        int height = rect[3] - rect[1];
        Rectangle bounds = new Rectangle(rect[0], rect[1], width, height);
        return bounds;
    }

    static void gtk_getBounds(int handle, Rectangle bounds) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
            Class[] params = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{handle};
            Method method = clazz.getMethod("GTK_WIDGET_X", params);
            bounds.x = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("GTK_WIDGET_Y", params);
            bounds.y = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("GTK_WIDGET_WIDTH", params);
            bounds.width = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("GTK_WIDGET_HEIGHT", params);
            bounds.height = (Integer)method.invoke(clazz, args);
        }
        catch (Throwable throwable) {}
    }

    static Rectangle gtk_getBounds(TableColumn tableColumn) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> c = tableColumn.getClass();
            Field f = c.getDeclaredField("buttonHandle");
            f.setAccessible(true);
            int handle = f.getInt(tableColumn);
            SWTWorkarounds.gtk_getBounds(handle, bounds);
        }
        catch (Throwable throwable) {}
        return bounds;
    }

    static Rectangle gtk_getBounds(TreeColumn treeColumn) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> c = treeColumn.getClass();
            Field f = c.getDeclaredField("buttonHandle");
            f.setAccessible(true);
            int handle = f.getInt(treeColumn);
            SWTWorkarounds.gtk_getBounds(handle, bounds);
        }
        catch (Throwable throwable) {}
        return bounds;
    }

    static Rectangle gtk_getBounds(TabItem tabItem) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> c = Class.forName("org.eclipse.swt.widgets.Widget");
            Field f = c.getDeclaredField("handle");
            f.setAccessible(true);
            int handle = f.getInt(tabItem);
            SWTWorkarounds.gtk_getBounds(handle, bounds);
        }
        catch (Throwable throwable) {}
        return bounds;
    }

    static Rectangle motif_getBounds(TabItem tabItem) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> c = tabItem.getClass();
            Method m = c.getDeclaredMethod("getBounds", new Class[0]);
            m.setAccessible(true);
            bounds = (Rectangle)m.invoke((Object)tabItem, new Object[0]);
            int margin = 2;
            bounds.x += margin;
            bounds.y += margin;
            bounds.width -= 2 * margin;
            bounds.height -= margin;
        }
        catch (Throwable throwable) {}
        return bounds;
    }

    static Rectangle motif_getBounds(TableColumn tableColumn) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> c = tableColumn.getClass();
            Method m = c.getDeclaredMethod("getX", new Class[0]);
            m.setAccessible(true);
            bounds.x = (Integer)m.invoke((Object)tableColumn, new Object[0]);
            bounds.width = tableColumn.getWidth() - 2;
            bounds.height = tableColumn.getParent().getHeaderHeight() - 2;
        }
        catch (Throwable throwable) {}
        return bounds;
    }

    static Rectangle motif_getBounds(TreeColumn treeColumn) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> c = treeColumn.getClass();
            Method m = c.getDeclaredMethod("getX", new Class[0]);
            m.setAccessible(true);
            bounds.x = (Integer)m.invoke((Object)treeColumn, null);
            bounds.width = treeColumn.getWidth() - 2;
            bounds.height = treeColumn.getParent().getHeaderHeight() - 2;
        }
        catch (Throwable throwable) {}
        return bounds;
    }

    static Rectangle carbon_getBounds(TabItem tabItem) {
        return tabItem.getBounds();
    }

    static Rectangle carbon_getBounds(TableColumn tableColumn) {
        return null;
    }

    static Rectangle carbon_getBounds(TreeColumn treeColumn) {
        return null;
    }

    static Rectangle cocoa_getBounds(TabItem tabItem) {
        return tabItem.getBounds();
    }

    static Rectangle cocoa_getBounds(TableColumn tableColumn) {
        return null;
    }

    static Rectangle cocoa_getBounds(TreeColumn treeColumn) {
        return null;
    }

    public static Rectangle getBounds(TabItem tabItem) {
        if (SWTUtil.IsWindows) {
            return SWTWorkarounds.win32_getBounds(tabItem);
        }
        if (SWTUtil.IsGTK) {
            return SWTWorkarounds.gtk_getBounds(tabItem);
        }
        if (SWTUtil.IsMotif) {
            return SWTWorkarounds.motif_getBounds(tabItem);
        }
        if (SWTUtil.IsCarbon) {
            return SWTWorkarounds.carbon_getBounds(tabItem);
        }
        if (SWTUtil.IsCocoa) {
            return SWTWorkarounds.cocoa_getBounds(tabItem);
        }
        return null;
    }

    public static Rectangle getBounds(TableColumn tableColumn) {
        if (SWTUtil.IsWindows) {
            return SWTWorkarounds.win32_getBounds(tableColumn);
        }
        if (SWTUtil.IsGTK) {
            return SWTWorkarounds.gtk_getBounds(tableColumn);
        }
        if (SWTUtil.IsMotif) {
            return SWTWorkarounds.motif_getBounds(tableColumn);
        }
        if (SWTUtil.IsCarbon) {
            return SWTWorkarounds.carbon_getBounds(tableColumn);
        }
        if (SWTUtil.IsCocoa) {
            return SWTWorkarounds.cocoa_getBounds(tableColumn);
        }
        return null;
    }

    public static Rectangle getBounds(TreeColumn treeColumn) {
        if (SWTUtil.IsWindows) {
            return SWTWorkarounds.win32_getBounds(treeColumn);
        }
        if (SWTUtil.IsGTK) {
            return SWTWorkarounds.gtk_getBounds(treeColumn);
        }
        if (SWTUtil.IsMotif) {
            return SWTWorkarounds.motif_getBounds(treeColumn);
        }
        if (SWTUtil.IsCarbon) {
            return SWTWorkarounds.carbon_getBounds(treeColumn);
        }
        if (SWTUtil.IsCocoa) {
            return SWTWorkarounds.cocoa_getBounds(treeColumn);
        }
        return null;
    }

    public static Rectangle getBounds(TableItem item) {
        return item.getBounds(0);
    }

    public static Rectangle getBounds(TreeItem item) {
        return item.getBounds();
    }

    public static Rectangle getBounds(CTabItem item) {
        return item.getBounds();
    }

    public static Rectangle getBounds(ToolItem item) {
        return item.getBounds();
    }

    public static Rectangle getBounds(CoolItem item) {
        return item.getBounds();
    }

    public static Rectangle getBounds(ExpandItem item) {
        if (item == null || item.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        ExpandBar parent = item.getParent();
        int x = parent.getSpacing();
        int y = 20;
        int width = parent.getSize().x - 2 * parent.getSpacing();
        int height = item.getHeaderHeight();
        if (item.getExpanded()) {
            height = item.getHeaderHeight() + item.getHeight();
        }
        if ((2 & item.getStyle()) != 0) {
            height = 1;
        } else if (item.getImage() != null) {
            width += item.getImage().getBounds().width;
        }
        int index = parent.indexOf(item);
        int Dheight = 0;
        int i = 0;
        while (i < index) {
            ExpandItem prev = parent.getItem(i);
            Dheight = prev.getExpanded() ? Dheight + prev.getHeight() + prev.getHeaderHeight() : (Dheight += prev.getHeaderHeight());
            ++i;
        }
        y = parent.getSpacing() * (index + 1) + parent.getBorderWidth() + Dheight;
        return new Rectangle(x, y, width, height);
    }
}

