/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.util;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class DisplayUtil {
    public static void asyncExec(Runnable runnable) {
        DisplayUtil.asyncExec(DisplayUtil.getDisplay(), runnable);
    }

    public static void asyncExec(Display display, Runnable runnable) {
        DisplayUtil.check(display).asyncExec(runnable);
    }

    private static Display check(Display display) {
        if (display == null) {
            display = DisplayUtil.getDisplay();
        }
        if (display == null) {
            throw new SWTException(5, "Invalid thread access");
        }
        return display;
    }

    public static void syncExec(Runnable runnable) {
        if (runnable != null) {
            DisplayUtil.getDisplay().syncExec(runnable);
        }
    }

    public static void syncExec(Display display, Runnable runnable) {
        DisplayUtil.check(display).syncExec(runnable);
    }

    public static void timerExec(int milliseconds, Runnable runnable) {
        if (runnable != null) {
            DisplayUtil.getDisplay().timerExec(milliseconds, runnable);
        }
    }

    public static void timerExec(Display display, int milliseconds, Runnable runnable) {
        DisplayUtil.check(display).timerExec(milliseconds, runnable);
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        return display;
    }
}

