/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.style;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.tools.ui.designer.core.DesignerPlugin;
import org.eclipse.e4.xwt.tools.ui.designer.core.style.StyleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTStyles {
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.e4.xwt.tools.ui.designer.core.style.styles");
    private static StyleGroup[] DEFINED_GROUPS;
    private static final Map<Class<?>, StyleGroup[]> stylesCache;

    static {
        stylesCache = new HashMap(1);
    }

    public static synchronized StyleGroup[] getDefinedGroups() {
        if (DEFINED_GROUPS == null) {
            Field[] feilds;
            ArrayList<StyleGroup> groups = new ArrayList<StyleGroup>();
            Field[] fieldArray = feilds = StyleGroup.class.getDeclaredFields();
            int n = feilds.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    Object object = field.get(null);
                    if (object != null && object instanceof StyleGroup) {
                        groups.add((StyleGroup)object);
                    }
                }
                catch (Exception e) {
                    DesignerPlugin.logInfo(e);
                }
                ++n2;
            }
            DEFINED_GROUPS = groups.toArray(new StyleGroup[0]);
        }
        return DEFINED_GROUPS;
    }

    public static StyleGroup[] getStyles(Class<?> type) {
        StyleGroup[] styleGroups = stylesCache.get(type);
        if (styleGroups == null) {
            StyleGroup[] definedGroups;
            ArrayList<StyleGroup> groups = new ArrayList<StyleGroup>();
            ArrayList<String> styles = new ArrayList<String>(SWTStyles.styles(type));
            Collections.sort(styles);
            StyleGroup[] styleGroupArray = definedGroups = SWTStyles.getDefinedGroups();
            int n = definedGroups.length;
            int n2 = 0;
            while (n2 < n) {
                StyleGroup grp = styleGroupArray[n2];
                if (grp.match(type, styles)) {
                    groups.add(grp);
                }
                ++n2;
            }
            for (StyleGroup added : groups) {
                styles.removeAll(Arrays.asList(added.getStyles()));
            }
            if (!styles.isEmpty()) {
                groups.add(new StyleGroup(type, "default", styles.toArray(new String[styles.size()])));
            }
            styleGroups = groups.toArray(new StyleGroup[groups.size()]);
            stylesCache.put(type, styleGroups);
        }
        return styleGroups;
    }

    public static StyleGroup getStyles(Class<?> type, String groupName) {
        StyleGroup[] styles;
        if (type == null || groupName == null) {
            return null;
        }
        StyleGroup[] styleGroupArray = styles = SWTStyles.getStyles(type);
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            StyleGroup styleGroup = styleGroupArray[n2];
            if (groupName.equals(styleGroup.getGroupName())) {
                return styleGroup;
            }
            ++n2;
        }
        return null;
    }

    private static Set<String> styles(Class<?> type) {
        HashSet<String> result = new HashSet<String>();
        String key = type.getName();
        if (RESOURCE_BUNDLE.getObject(key) == null) {
            return Collections.emptySet();
        }
        String value = RESOURCE_BUNDLE.getString(key);
        if (value != null) {
            StringTokenizer stk = new StringTokenizer(value, ",");
            while (stk.hasMoreElements()) {
                result.add(stk.nextToken().trim());
            }
        } else {
            Class<?> superclass = type.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                result.addAll(SWTStyles.styles(superclass));
            }
        }
        return result;
    }
}

