/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation;

import org.eclipse.e4.xwt.animation.Duration;
import org.eclipse.e4.xwt.animation.FillBehavior;
import org.eclipse.e4.xwt.animation.RepeatBehavior;
import org.eclipse.e4.xwt.animation.TimeSpan;
import org.pushingpixels.trident.Timeline;

public abstract class Timeline {
    public static Timeline[] EMPTY_ARRAY = new Timeline[0];
    protected int desiredFrameRate = 0;
    protected double accelerationRatio = 0.0;
    protected boolean autoReverse = false;
    protected TimeSpan beginTime = null;
    protected double decelerationRatio = 0.0;
    protected Duration duration = Duration.getAutomatic();
    protected FillBehavior fillBehavior = FillBehavior.HoldEnd;
    protected String name;
    protected double speedRatio = 0.0;
    protected RepeatBehavior repeatBehavior = RepeatBehavior.once;
    private org.pushingpixels.trident.Timeline timeline;

    public int getDesiredFrameRate() {
        return this.desiredFrameRate;
    }

    public void setDesiredFrameRate(int desiredFrameRate) {
        this.desiredFrameRate = desiredFrameRate;
    }

    public double getAccelerationRatio() {
        return this.accelerationRatio;
    }

    public void setAccelerationRatio(double accelerationRatio) {
        this.accelerationRatio = accelerationRatio;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    public TimeSpan getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(TimeSpan beginTime) {
        this.beginTime = beginTime;
    }

    public double getDecelerationRatio() {
        return this.decelerationRatio;
    }

    public void setDecelerationRatio(double decelerationRatio) {
        this.decelerationRatio = decelerationRatio;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public FillBehavior getFillBehavior() {
        return this.fillBehavior;
    }

    public void setFillBehavior(FillBehavior fillBehavior) {
        this.fillBehavior = fillBehavior;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getSpeedRatio() {
        return this.speedRatio;
    }

    public void setSpeedRatio(double speedRatio) {
        this.speedRatio = speedRatio;
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public void setRepeatBehavior(RepeatBehavior repeatBehavior) {
        this.repeatBehavior = repeatBehavior;
    }

    public void start(Object target) {
        this.timeline = new org.pushingpixels.trident.Timeline(this.findTarget(target));
        if (this.duration != null && this.duration.hasTimeSpan()) {
            this.timeline.setDuration((long)this.duration.getTimeSpan().getMilliseconds());
        } else {
            this.timeline.setDuration(10000L);
        }
        this.doStart(this.timeline, target);
        this.playLoop(this.getRepeatBehavior());
    }

    protected Object findTarget(Object target) {
        return target;
    }

    public void stop() {
        if (this.timeline == null) {
            return;
        }
        this.timeline.abort();
        this.timeline = null;
    }

    public void pause() {
        if (this.timeline == null) {
            return;
        }
        this.timeline.suspend();
    }

    public void resume() {
        if (this.timeline == null) {
            return;
        }
        this.timeline.resume();
    }

    public void playReverse() {
        if (this.timeline == null) {
            return;
        }
        this.timeline.playReverse();
    }

    public void playLoop(RepeatBehavior behavior) {
        if (this.timeline == null) {
            return;
        }
        Timeline.RepeatBehavior loopBehavior = Timeline.RepeatBehavior.LOOP;
        if (this.isAutoReverse()) {
            loopBehavior = Timeline.RepeatBehavior.REVERSE;
        }
        if (behavior.getHasCount()) {
            double loopCount = behavior.getCount();
            if (!behavior.getHasDuration()) {
                this.timeline.playLoop((int)loopCount, loopBehavior);
            } else {
                Duration duration = behavior.getDuration();
                this.timeline.playLoopSkipping((int)loopCount, loopBehavior, (long)duration.getTimeSpan().getMilliseconds());
            }
        } else if (!behavior.getHasDuration()) {
            this.timeline.playLoop(loopBehavior);
        } else {
            Duration duration = behavior.getDuration();
            this.timeline.playLoopSkipping(loopBehavior, (long)duration.getTimeSpan().getMilliseconds());
        }
    }

    protected abstract void doStart(org.pushingpixels.trident.Timeline var1, Object var2);
}

