/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;

public class InjectStaticContextTest
extends TestCase {
    public void testStaticMake() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("a", (Object)"abc");
        parentContext.set("aConstructor", (Object)"abcConstructor");
        parentContext.set("b", (Object)"bbc");
        IEclipseContext localContext = EclipseContextFactory.create();
        localContext.set("b", (Object)"123");
        localContext.set("bConstructor", (Object)"123Constructor");
        localContext.set("c", (Object)"xyz");
        TestClass testObject = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)parentContext, (IEclipseContext)localContext);
        InjectStaticContextTest.assertEquals((Object)localContext, (Object)testObject.injectedContext);
        InjectStaticContextTest.assertEquals((String)"abcConstructor", (String)testObject.aConstructorString);
        InjectStaticContextTest.assertEquals((String)"123Constructor", (String)testObject.bConstructorString);
        InjectStaticContextTest.assertEquals((String)"abc", (String)testObject.aString);
        InjectStaticContextTest.assertEquals((String)"123", (String)testObject.bString);
        InjectStaticContextTest.assertEquals((String)"xyz", (String)testObject.cString);
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.postConstructCalled);
        InjectStaticContextTest.assertEquals((int)0, (int)testObject.preDestroyCalled);
        localContext.set("b", (Object)"_123_");
        localContext.set("bConstructor", (Object)"_123Constructor_");
        localContext.set("c", (Object)"_xyz_");
        InjectStaticContextTest.assertEquals((String)"abcConstructor", (String)testObject.aConstructorString);
        InjectStaticContextTest.assertEquals((String)"123Constructor", (String)testObject.bConstructorString);
        InjectStaticContextTest.assertEquals((String)"abc", (String)testObject.aString);
        InjectStaticContextTest.assertEquals((String)"123", (String)testObject.bString);
        InjectStaticContextTest.assertEquals((String)"xyz", (String)testObject.cString);
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.postConstructCalled);
        InjectStaticContextTest.assertEquals((int)0, (int)testObject.preDestroyCalled);
        localContext.dispose();
        InjectStaticContextTest.assertEquals((String)"abcConstructor", (String)testObject.aConstructorString);
        InjectStaticContextTest.assertEquals((String)"123Constructor", (String)testObject.bConstructorString);
        InjectStaticContextTest.assertEquals((String)"abc", (String)testObject.aString);
        InjectStaticContextTest.assertEquals((String)"123", (String)testObject.bString);
        InjectStaticContextTest.assertEquals((String)"xyz", (String)testObject.cString);
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.postConstructCalled);
        InjectStaticContextTest.assertEquals((int)0, (int)testObject.preDestroyCalled);
        parentContext.set("a", (Object)"_abc_");
        parentContext.set("b", (Object)"_bbc_");
        InjectStaticContextTest.assertEquals((String)"_abc_", (String)testObject.aString);
        InjectStaticContextTest.assertEquals((String)"123", (String)testObject.bString);
        ContextInjectionFactory.uninject((Object)testObject, (IEclipseContext)parentContext);
        InjectStaticContextTest.assertNull((Object)testObject.injectedContext);
        InjectStaticContextTest.assertNull((Object)testObject.aString);
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.postConstructCalled);
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.preDestroyCalled);
        parentContext.set("a", (Object)"+abc+");
        InjectStaticContextTest.assertNull((Object)testObject.aString);
        parentContext.dispose();
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.postConstructCalled);
        InjectStaticContextTest.assertEquals((int)1, (int)testObject.preDestroyCalled);
    }

    public void testStaticInvoke() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("a", (Object)"abc");
        IEclipseContext localContext = EclipseContextFactory.create();
        localContext.set("b", (Object)"123");
        TestInvokeClass testObject = new TestInvokeClass();
        InjectStaticContextTest.assertNull((Object)testObject.aString);
        InjectStaticContextTest.assertNull((Object)testObject.bString);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)parentContext, (IEclipseContext)localContext, null);
        InjectStaticContextTest.assertEquals((Object)"abc123", (Object)result);
        InjectStaticContextTest.assertEquals((String)"abc", (String)testObject.aString);
        InjectStaticContextTest.assertEquals((String)"123", (String)testObject.bString);
    }

    static class TestClass {
        public IEclipseContext injectedContext;
        public String aString;
        public String bString;
        public String cString;
        public String aConstructorString;
        public String bConstructorString;
        public int postConstructCalled = 0;
        public int preDestroyCalled = 0;

        TestClass() {
        }

        @Inject
        public void contextSet(IEclipseContext context) {
            this.injectedContext = context;
        }

        @Inject
        public void setA(@Named(value="a") String aString) {
            this.aString = aString;
        }

        @Inject
        public void setB(@Named(value="b") String bString) {
            this.bString = bString;
        }

        @Inject
        public void setC(@Named(value="c") String cString) {
            this.cString = cString;
        }

        @Inject
        public void InjectedMethod(@Named(value="aConstructor") String aString, @Named(value="bConstructor") String bString) {
            this.aConstructorString = aString;
            this.bConstructorString = bString;
        }

        @PostConstruct
        public void init() {
            ++this.postConstructCalled;
        }

        @PreDestroy
        public void dispose() {
            ++this.preDestroyCalled;
        }
    }

    static class TestInvokeClass {
        public String aString;
        public String bString;

        TestInvokeClass() {
        }

        @Execute
        public String testMethod(@Named(value="a") String aString, @Named(value="b") String bString) {
            this.aString = aString;
            this.bString = bString;
            return String.valueOf(aString) + bString;
        }
    }
}

