/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.Resource;
import org.eclipse.dirigible.ide.workspace.impl.Workspace;
import org.eclipse.dirigible.ide.workspace.impl.event.ResourceChangeEvent;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;

public class File
extends Resource
implements IFile {
    private static final String ROLLBACK_NOT_SUPPORTED = Messages.File_ROLLBACK_NOT_SUPPORTED;
    private static final String COULD_NOT_WRITE_TO_FILE = Messages.File_COULD_NOT_WRITE_TO_FILE;
    private static final String COULD_NOT_READ_FILE = Messages.File_COULD_NOT_READ_FILE;
    private static final String FILE_DOES_NOT_EXIST = Messages.File_FILE_DOES_NOT_EXIST;
    private static final String COULD_NOT_CREATE_RESOURCE = Messages.File_COULD_NOT_CREATE_RESOURCE;
    private static final String OWNER_PROJECT_IS_NOT_OPEN = Messages.File_OWNER_PROJECT_IS_NOT_OPEN;
    private static final String PARENT_DOES_NOT_EXIST = Messages.File_PARENT_DOES_NOT_EXIST;
    private static final String A_RESOURCE_WITH_THIS_PATH_EXISTS = Messages.File_A_RESOURCE_WITH_THIS_PATH_EXISTS;
    private static final String COULD_NOT_APPEND_CONTENTS = Messages.File_COULD_NOT_APPEND_CONTENTS;
    private static final String RESOURCE_DOES_NOT_EXIST = Messages.File_RESOURCE_DOES_NOT_EXIST;
    private String charset = null;
    private static final Logger logger = Logger.getLogger(File.class);

    public File(IPath path, Workspace workspace) {
        super(path, workspace);
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = File.monitorWrapper(monitor);
        try {
            if (monitor != null) {
                monitor.beginTask("appending file contents", -1);
            }
            if (!this.exists()) {
                throw new CoreException(File.createErrorStatus(RESOURCE_DOES_NOT_EXIST));
            }
            try {
                IResource resource = (IResource)this.getEntity();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] content = resource.getContent();
                out.write(content);
                File.copyStream(source, out);
                resource.setContent(out.toByteArray());
            }
            catch (IOException ex) {
                throw new CoreException(File.createErrorStatus(COULD_NOT_APPEND_CONTENTS, ex));
            }
            this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.appendContents(source, flags, monitor);
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = force ? 1 : 0;
        this.create(source, flags, monitor);
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = File.monitorWrapper(monitor);
        try {
            IStatus pathValidation;
            if (monitor != null) {
                monitor.beginTask("file creation", -1);
            }
            if (!(pathValidation = this.workspace.validatePath(this.path.toString(), 1)).isOK()) {
                throw new CoreException(pathValidation);
            }
            if (this.workspace.hasResource(this.getLocation())) {
                throw new CoreException(File.createErrorStatus(A_RESOURCE_WITH_THIS_PATH_EXISTS));
            }
            if (!this.getParent().exists()) {
                throw new CoreException(File.createErrorStatus(PARENT_DOES_NOT_EXIST));
            }
            if (!this.getProject().isOpen()) {
                throw new CoreException(File.createErrorStatus(OWNER_PROJECT_IS_NOT_OPEN));
            }
            try {
                IResource resource = (IResource)this.getEntity();
                resource.setContent(File.readContent(source), this.isBinary(), this.getContentType());
            }
            catch (IOException ex) {
                throw new CoreException(File.createErrorStatus(String.valueOf(COULD_NOT_CREATE_RESOURCE) + this.getName(), ex));
            }
            this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static byte[] readContent(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        return out.toByteArray();
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.delete(flags, monitor);
    }

    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        if (checkImplicit) {
            if (this.charset != null) {
                return this.charset;
            }
            return this.getParent().getDefaultCharset();
        }
        return this.exists() ? this.charset : null;
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        if (this.exists()) {
            return this.getCharset(false);
        }
        return this.getParent().getDefaultCharset();
    }

    public IContentDescription getContentDescription() throws CoreException {
        return null;
    }

    public InputStream getContents() throws CoreException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws CoreException {
        if (!this.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dirigible.ide.workspace", FILE_DOES_NOT_EXIST));
        }
        try {
            IResource resource = (IResource)this.getEntity();
            return new ByteArrayInputStream(resource.getContent());
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dirigible.ide.workspace", COULD_NOT_READ_FILE));
        }
    }

    @Deprecated
    public int getEncoding() throws CoreException {
        return 3;
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return new IFileState[0];
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.move(destination, flags, monitor);
    }

    @Deprecated
    public void setCharset(String newCharset) throws CoreException {
        this.setCharset(newCharset, null);
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        this.charset = newCharset;
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = File.monitorWrapper(monitor);
        try {
            if (monitor != null) {
                monitor.beginTask("file content change", -1);
            }
            if (!this.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dirigible.ide.workspace", FILE_DOES_NOT_EXIST));
            }
            try {
                IResource resource = (IResource)this.getEntity();
                ByteArrayOutputStream out = new ByteArrayOutputStream(source.available());
                File.copyStream(source, out);
                resource.setContent(out.toByteArray());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dirigible.ide.workspace", COULD_NOT_WRITE_TO_FILE));
            }
            this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(ROLLBACK_NOT_SUPPORTED);
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.setContents(source, flags, monitor);
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.setContents(source, flags, monitor);
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
    }

    private String getContentType() {
        return ContentTypeHelper.getContentType((String)this.getFileExtension());
    }

    private boolean isBinary() {
        return ContentTypeHelper.isBinary((String)ContentTypeHelper.getContentType((String)this.getFileExtension()));
    }

    public IPathVariableManager getPathVariableManager() {
        return null;
    }

    public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
    }
}

