/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.publish;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.logging.Logger;

public class UiPublisher
extends AbstractPublisher
implements IPublisher {
    private static final Logger logger = Logger.getLogger(UiPublisher.class);

    public void publish(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation(), request);
            IFolder sourceFolder = this.getSourceFolder(project, "WebContent");
            logger.debug("Copy all from " + sourceFolder.getFullPath().toString() + " to folder: " + targetContainer.getPath());
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getSandboxLocation(request), request);
            IFolder sourceFolder = this.getSourceFolder(project, "WebContent");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String getSandboxLocation(HttpServletRequest request) {
        return CommonIDEParameters.getWebContentSandbox((HttpServletRequest)request);
    }

    public String getFolderType() {
        return "WebContent";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file);
    }

    public String getPublishedContainerMapping(IFile file) {
        return "/web";
    }

    public String getActivatedContainerMapping(IFile file) {
        return "/web-sandbox";
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/WebContent";
    }

    public void template(IProject project, HttpServletRequest request) throws PublishException {
    }
}

