/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class TemplateUtils {
    private static final Logger logger = Logger.getLogger(TemplateUtils.class);
    private static final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static Image createImageFromResource(ICollection collection, String imageName) throws IOException {
        IResource imageResource = collection.getResource(imageName);
        if (!imageResource.exists()) {
            throw new IOException(String.format("Template image does not exist at: %s", imageName));
        }
        Image image = TemplateUtils.createImage(imageResource.getContent());
        return image;
    }

    public static Image createImageFromResource(String imagePath) throws IOException {
        IResource imageResource = RepositoryFacade.getInstance().getRepository().getResource(imagePath);
        if (!imageResource.exists()) {
            throw new IOException(String.format("Template image does not exist at: %s", imagePath));
        }
        Image image = TemplateUtils.createImage(imageResource.getContent());
        return image;
    }

    public static Image createImageFromStream(File project, String imageName) throws IOException, FileNotFoundException {
        String imgPath = String.valueOf(project.getCanonicalPath()) + "/" + imageName;
        File imgFile = new File(imgPath);
        byte[] imgContent = IOUtils.toByteArray((InputStream)new FileInputStream(imgFile));
        Image image = TemplateUtils.createImage(imgContent);
        return image;
    }

    private static Image createImage(byte[] data) {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)new ByteArrayInputStream(data)));
            return resourceManager.createImage(imageDescriptor);
        }
        catch (SWTException ex) {
            logger.warn(ex.getMessage());
            return null;
        }
    }
}

