/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.dirigible.ide.common.ExtensionPointUtils;
import org.eclipse.dirigible.ide.common.image.ImageUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypeDescriptor;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypeException;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypePageLabelProvider;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypesEnumerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateUtils;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class TemplateTypeWizardPage
extends WizardPage {
    private static final String EXTENSION_POINT_0_COULD_NOT_BE_FOUND = Messages.TemplateTypeWizardPage_EXTENSION_POINT_0_COULD_NOT_BE_FOUND;
    private static final long serialVersionUID = -5435162447712125969L;
    private static final String EMPTY_STRING = "";
    private static final String ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION = Messages.TemplateTypeWizardPage_ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION;
    private static final String SELECT_TEMPLATE_TYPE_FORM_THE_LIST = Messages.TemplateTypeWizardPage_SELECT_TEMPLATE_TYPE_FORM_THE_LIST;
    private static final String AVAILABLE_TEMPLATES = Messages.TemplateTypeWizardPage_AVAILABLE_TEMPLATES;
    private static final String TEMPLATE_TYPE_EXTENSION_POINT_ID = "org.eclipse.dirigible.ide.template.type";
    private static final String TEMPLATE_TYPE_ELEMENT_NAME = "template";
    private static final String TEMPLATE_TYPE_TEXT_ATTRIBUTE = "text";
    private static final String TEMPLATE_TYPE_LOCATION_ATTRIBUTE = "location";
    private static final String TEMPLATE_TYPE_IMAGE_ATTRIBUTE = "image";
    private static final String TEMPLATE_TYPE_PREVIEW_ATTRIBUTE = "preview";
    private static final String TEMPLATE_TYPE_CATEGORY_ATTRIBUTE = "category";
    private static final String TEMPLATE_TYPE_PARAMETER_ATTRIBUTE = "parameter";
    private static final String TEMPLATE_TYPE_VALUE_ATTRIBUTE = "value";
    private static final Logger logger = Logger.getLogger(TemplateTypeWizardPage.class);
    private TableViewer typeViewer;
    private Label labelPreview;
    private static final Image previewImage = ImageUtils.createImage((URL)TemplateTypeWizardPage.getIconURL("preview.png"));

    protected TemplateTypeWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract GenerationModel getModel();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTypeField((Composite)sashForm);
        this.createPreviewLabel((Composite)sashForm);
        sashForm.setWeights(new int[]{70, 30});
        composite.pack(true);
        this.checkPageStatus();
    }

    public static URL getIconURL(String iconName) {
        URL url = ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.template.ui.common", (String)"/icons/", (String)iconName);
        return url;
    }

    private void createPreviewLabel(Composite composite) {
        Composite indexComposite = new Composite(composite, 0);
        GridLayout flat = new GridLayout();
        flat.horizontalSpacing = 0;
        flat.marginWidth = 0;
        indexComposite.setLayout((Layout)flat);
        this.labelPreview = new Label(indexComposite, 0);
        this.labelPreview.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.labelPreview.setBounds(0, 0, 450, 300);
        this.labelPreview.setBackground(new Color(null, 255, 255, 255));
        this.labelPreview.setImage(previewImage);
    }

    private void createTypeField(Composite parent) {
        Composite indexComposite = new Composite(parent, 0);
        GridLayout flat = new GridLayout();
        flat.horizontalSpacing = 0;
        flat.marginWidth = 0;
        indexComposite.setLayout((Layout)flat);
        GridData gridDataTable = new GridData();
        gridDataTable.horizontalAlignment = 4;
        gridDataTable.verticalAlignment = 4;
        gridDataTable.grabExcessHorizontalSpace = true;
        gridDataTable.grabExcessVerticalSpace = true;
        gridDataTable.horizontalIndent = 0;
        Label label = new Label(indexComposite, 0);
        label.setText(AVAILABLE_TEMPLATES);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.typeViewer = new TableViewer(indexComposite, 2564);
        this.typeViewer.getControl().setLayoutData((Object)gridDataTable);
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new TemplateTypePageLabelProvider());
        TemplateType[] templateTypes = this.createTemplateTypes();
        this.typeViewer.setInput((Object)templateTypes);
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() == null || !(selection.getFirstElement() instanceof TemplateType)) {
                    TemplateTypeWizardPage.this.setErrorMessage(SELECT_TEMPLATE_TYPE_FORM_THE_LIST);
                    TemplateTypeWizardPage.this.labelPreview.setImage(previewImage);
                    TemplateTypeWizardPage.this.labelPreview.pack(true);
                } else {
                    TemplateTypeWizardPage.this.setErrorMessage(null);
                    TemplateType templateType = (TemplateType)selection.getFirstElement();
                    TemplateTypeWizardPage.this.getModel().setTemplate(templateType);
                    String preview = templateType.getTemplateMetadata().getPreview();
                    if (preview != null) {
                        Image image = TemplateTypeWizardPage.this.getPreviewImage(preview);
                        if (image != null) {
                            TemplateTypeWizardPage.this.labelPreview.setImage(image);
                        } else {
                            TemplateTypeWizardPage.this.labelPreview.setImage(previewImage);
                        }
                    } else {
                        TemplateTypeWizardPage.this.labelPreview.setImage(previewImage);
                    }
                    TemplateTypeWizardPage.this.labelPreview.pack(true);
                }
                TemplateTypeWizardPage.this.checkPageStatus();
            }
        });
    }

    private Image getPreviewImage(String imageLocation) {
        Image image;
        try {
            image = TemplateUtils.createImageFromResource(imageLocation);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            return null;
        }
        return image;
    }

    private TemplateType[] createTemplateTypes() {
        try {
            TemplateType[] templateTypes = this.prepareTemplateTypes();
            return templateTypes;
        }
        catch (IOException e) {
            logger.error(ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION, (Throwable)e);
            return null;
        }
    }

    private void checkPageStatus() {
        if (this.getModel().getTemplateLocation() == null || EMPTY_STRING.equals(this.getModel().getTemplateLocation())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.getModel().validateTemplate();
        if (status.hasErrors()) {
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(true);
        }
    }

    public List<TemplateTypeDescriptor> getTemplateTypeDescriptors(String category) {
        IConfigurationElement[] templateTypeDescriptorElements;
        ArrayList<TemplateTypeDescriptor> templateTypeDescriptors = new ArrayList<TemplateTypeDescriptor>();
        IExtensionPoint extensionPoint = ExtensionPointUtils.getExtensionPoint((String)TEMPLATE_TYPE_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            throw new TemplateTypeException(MessageFormat.format(EXTENSION_POINT_0_COULD_NOT_BE_FOUND, TEMPLATE_TYPE_EXTENSION_POINT_ID));
        }
        IConfigurationElement[] iConfigurationElementArray = templateTypeDescriptorElements = this.getTemplateElements(extensionPoint.getExtensions());
        int n = templateTypeDescriptorElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement templateTypeDescriptorElement = iConfigurationElementArray[n2];
            TemplateTypeDescriptor templateTypeDescriptor = this.createTemplateTypeDescriptor(category, templateTypeDescriptorElement);
            if (templateTypeDescriptor != null) {
                templateTypeDescriptors.add(templateTypeDescriptor);
            }
            ++n2;
        }
        return templateTypeDescriptors;
    }

    private IConfigurationElement[] getTemplateElements(IExtension[] extensions) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (TEMPLATE_TYPE_ELEMENT_NAME.equals(element.getName())) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    private TemplateTypeDescriptor createTemplateTypeDescriptor(String category, IConfigurationElement templateTypeDescriptorElement) {
        if (category.equals(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_CATEGORY_ATTRIBUTE))) {
            IConfigurationElement[] parameterElements;
            TemplateTypeDescriptor templateTypeDescriptor = new TemplateTypeDescriptor();
            templateTypeDescriptor.setText(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_TEXT_ATTRIBUTE));
            templateTypeDescriptor.setLocation(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_LOCATION_ATTRIBUTE));
            templateTypeDescriptor.setImage(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_IMAGE_ATTRIBUTE));
            templateTypeDescriptor.setPreview(templateTypeDescriptorElement.getAttribute(TEMPLATE_TYPE_PREVIEW_ATTRIBUTE));
            HashSet<String> parameters = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = parameterElements = templateTypeDescriptorElement.getChildren(TEMPLATE_TYPE_PARAMETER_ATTRIBUTE);
            int n = parameterElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement parameterElement = iConfigurationElementArray[n2];
                parameters.add(parameterElement.getAttribute(TEMPLATE_TYPE_VALUE_ATTRIBUTE));
                ++n2;
            }
            templateTypeDescriptor.setParameters(parameters);
            return templateTypeDescriptor;
        }
        return null;
    }

    protected TemplateType[] prepareTemplateTypes() throws IOException {
        return TemplateTypesEnumerator.prepareTemplateTypes(this.getTemplatesPath(), this.getCategory());
    }

    protected abstract String getTemplatesPath();

    protected abstract String getCategory();
}

