/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.viewer.ReservedFolderFilter;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceContainerFilter;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class TemplateTargetLocationPage
extends WizardPage {
    private static final String THERE_IS_NO_SELECTED_PROJECT = "There is no selected project";
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    private static final String INPUT_THE_FILE_NAME = Messages.TemplateTargetLocationPage_INPUT_THE_FILE_NAME;
    private static final String INPUT_THE_PACKAGE_NAME = Messages.TemplateTargetLocationPage_INPUT_THE_PACKAGE_NAME;
    private static final String SELECT_THE_LOCATION_OF_THE_GENERATED_PAGE = Messages.TemplateTargetLocationPage_SELECT_THE_LOCATION_OF_THE_GENERATED_PAGE;
    private WorkspaceViewer projectViewer;
    private Text packageNameText;
    private Text fileNameText;
    private String targetLocation = null;
    private boolean packageUserInput = false;
    private boolean fileUserInput = false;
    boolean selectInitial = false;

    protected abstract GenerationModel getModel();

    protected TemplateTargetLocationPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createProjectViewerField(composite);
        this.createPackageNameField(composite);
        this.createFileNameField(composite);
        this.checkPageStatus();
    }

    private void setPreselectedElement() {
        if (!this.selectInitial) {
            this.projectViewer.getViewer().setSelection((ISelection)this.getPreselectedElement(), true);
            this.selectInitial = true;
        }
    }

    private void createProjectViewerField(Composite parent) {
        this.projectViewer = new WorkspaceViewer(parent, 2048);
        this.projectViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.projectViewer.getViewer().addFilter(this.getFilter());
        this.projectViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TemplateTargetLocationPage.this.projectViewer.getSelectionProvider().getSelection();
                if (selection.getFirstElement() == null || !(selection.getFirstElement() instanceof IContainer)) {
                    TemplateTargetLocationPage.this.setErrorMessage(SELECT_THE_LOCATION_OF_THE_GENERATED_PAGE);
                } else {
                    TemplateTargetLocationPage.this.setErrorMessage(null);
                    IContainer container = (IContainer)selection.getFirstElement();
                    TemplateTargetLocationPage.this.targetLocation = container.getFullPath().toString();
                    TemplateTargetLocationPage.this.getModel().setTargetContainer(TemplateTargetLocationPage.this.targetLocation);
                    if (container.getProjectRelativePath().segmentCount() <= 1) {
                        if (TemplateTargetLocationPage.this.getModel().getProjectName() != null) {
                            TemplateTargetLocationPage.this.getModel().setProjectPackageName(TemplateTargetLocationPage.this.getModel().getProjectName());
                        } else if (WorkspaceLocator.getWorkspace().getRoot().getProjects().length == 0) {
                            TemplateTargetLocationPage.this.setErrorMessage(TemplateTargetLocationPage.THERE_IS_NO_SELECTED_PROJECT);
                        } else {
                            TemplateTargetLocationPage.this.getModel().setProjectPackageName(WorkspaceLocator.getWorkspace().getRoot().getProjects()[0].getName());
                        }
                    } else {
                        String packageName = TemplateTargetLocationPage.this.getModel().genPackageName();
                        TemplateTargetLocationPage.this.getModel().setProjectPackageName(packageName);
                        TemplateTargetLocationPage.this.packageNameText.setText(packageName);
                        TemplateTargetLocationPage.this.packageNameText.setEnabled(false);
                        TemplateTargetLocationPage.this.packageUserInput = false;
                    }
                }
                TemplateTargetLocationPage.this.checkPageStatus();
            }
        });
        this.projectViewer.getViewer().expandToLevel(2);
    }

    protected ViewerFilter getFilter() {
        if (this.getArtifactContainerName() == null) {
            return new WorkspaceContainerFilter();
        }
        return new ReservedFolderFilter(this.getArtifactContainerName());
    }

    protected String getArtifactContainerName() {
        return null;
    }

    protected Object getApropriateFolderForAction(String folderName) {
        block9: {
            int n;
            Object[] expandedElements = this.projectViewer.getViewer().getExpandedElements();
            if (expandedElements == null || expandedElements.length == 0) {
                return null;
            }
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.projectViewer.getViewer().getContentProvider();
            IResource sourceResource = this.getModel().getSourceResource();
            if (sourceResource != null) {
                String[] segments;
                String[] stringArray = segments = sourceResource.getLocation().segments();
                n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if (segment.equals(folderName)) {
                        return sourceResource;
                    }
                    ++n2;
                }
            }
            try {
                if (sourceResource != null) {
                    Object[] children;
                    IProject project = sourceResource.getProject();
                    Object[] objectArray = children = contentProvider.getChildren((Object)project);
                    int n3 = children.length;
                    n = 0;
                    while (n < n3) {
                        Object object = objectArray[n];
                        IResource r = (IResource)object;
                        if (r instanceof IFolder && r.getName().equals(folderName)) {
                            return r;
                        }
                        ++n;
                    }
                    break block9;
                }
                return null;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return null;
    }

    private void createFileNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText(Messages.TemplateTargetLocationPage_FILE_NAME);
        this.fileNameText = new Text(parent, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileNameText.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 72329751007839679L;

            public void modifyText(ModifyEvent event) {
                TemplateTargetLocationPage.this.fileUserInput = true;
                if (TemplateTargetLocationPage.this.fileNameText.getText() == null || TemplateTargetLocationPage.EMPTY_STRING.equals(TemplateTargetLocationPage.this.fileNameText.getText())) {
                    TemplateTargetLocationPage.this.setErrorMessage(INPUT_THE_FILE_NAME);
                } else {
                    TemplateTargetLocationPage.this.setErrorMessage(null);
                    TemplateTargetLocationPage.this.getModel().setFileName(TemplateTargetLocationPage.this.fileNameText.getText());
                }
                TemplateTargetLocationPage.this.checkPageStatus();
            }
        });
    }

    private void createPackageNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText(Messages.TemplateTargetLocationPage_PACKAGE_NAME);
        this.packageNameText = new Text(parent, 2048);
        this.packageNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.packageNameText.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 72329751007839679L;

            public void modifyText(ModifyEvent event) {
                TemplateTargetLocationPage.this.packageUserInput = true;
                if (TemplateTargetLocationPage.this.packageNameText.getText() == null || TemplateTargetLocationPage.EMPTY_STRING.equals(TemplateTargetLocationPage.this.packageNameText.getText())) {
                    TemplateTargetLocationPage.this.setErrorMessage(INPUT_THE_PACKAGE_NAME);
                } else {
                    TemplateTargetLocationPage.this.setErrorMessage(null);
                    TemplateTargetLocationPage.this.getModel().setProjectPackageName(TemplateTargetLocationPage.this.packageNameText.getText());
                    if (!TemplateTargetLocationPage.this.targetLocation.endsWith(TemplateTargetLocationPage.this.packageNameText.getText())) {
                        TemplateTargetLocationPage.this.getModel().setTargetContainer(String.valueOf(TemplateTargetLocationPage.this.targetLocation) + "/" + TemplateTargetLocationPage.this.packageNameText.getText());
                    }
                }
                TemplateTargetLocationPage.this.checkPageStatus();
            }
        });
    }

    protected void checkPageStatus() {
        if (this.getModel().getTargetLocation() == null || EMPTY_STRING.equals(this.getModel().getTargetLocation())) {
            this.setPageComplete(false);
            return;
        }
        if (this.getModel().getFileName() == null || EMPTY_STRING.equals(this.getModel().getFileName())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.getModel().validateLocation();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected abstract String getDefaultFileName(String var1);

    public void setVisible(boolean visible) {
        this.setPreselectedElement();
        if (this.packageNameText.isEnabled() && !this.packageUserInput) {
            String packageName = this.getDefaultPackageName();
            this.packageNameText.setText(packageName == null ? EMPTY_STRING : packageName);
        }
        if (this.fileNameText.getText() == null || EMPTY_STRING.equals(this.fileNameText.getText()) && !this.fileUserInput) {
            this.fileNameText.setText(this.getDefaultFileName(null));
        } else if (this.isForcedFileName() && !this.fileUserInput) {
            this.fileNameText.setText(this.getDefaultFileName(this.fileNameText.getText()));
        }
        super.setVisible(visible);
        this.preselectFileNameText();
    }

    private String getDefaultPackageName() {
        return this.getModel().getProjectPackageName() == null ? this.getModel().getProjectName() : this.getModel().getProjectPackageName();
    }

    private void preselectFileNameText() {
        this.fileNameText.setFocus();
        String defaultName = this.getDefaultFileName(this.fileNameText.getText());
        if (defaultName != null && defaultName.length() > 0) {
            int lastIndexOf = defaultName.indexOf(".");
            if (lastIndexOf == -1) {
                lastIndexOf = defaultName.length();
            }
            this.fileNameText.setSelection(0, lastIndexOf);
        }
    }

    protected StructuredSelection getPreselectedElement() {
        Object byName;
        if (this.getArtifactContainerName() != null && (byName = this.getApropriateFolderForAction(this.getArtifactContainerName())) != null) {
            return new StructuredSelection(byName);
        }
        return new StructuredSelection();
    }

    protected boolean isForcedFileName() {
        return false;
    }
}

