/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.net.URL;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewer;
import org.eclipse.dirigible.ide.db.viewer.views.TreeParent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DatabaseViewLabelProvider
extends LabelProvider {
    private static final long serialVersionUID = 7440464384326831067L;
    private static final String ICONS_SEGMENT = "/icons/";
    private static final URL TYPE_SCHEMA_ICON_URL = DatabaseViewLabelProvider.getIconURL("icon-schema.png");
    private static final URL TYPE_TABLE_ICON_URL = DatabaseViewLabelProvider.getIconURL("icon-table.png");
    private final DatabaseViewer databaseViewer;
    private final ResourceManager resourceManager;

    DatabaseViewLabelProvider(DatabaseViewer databaseViewer) {
        this.databaseViewer = databaseViewer;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public String getText(Object obj) {
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof TreeParent) {
            return this.createImage(TYPE_SCHEMA_ICON_URL);
        }
        return this.createImage(TYPE_TABLE_ICON_URL);
    }

    private Image createImage(URL imageURL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        return this.resourceManager.createImage(imageDescriptor);
    }

    private static URL getIconURL(String iconName) {
        return DatabaseViewLabelProvider.class.getResource(ICONS_SEGMENT + iconName);
    }
}

