/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.Messages;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProviderBase;

public class RepositoryModuleSourceProvider
extends ModuleSourceProviderBase {
    private static final long serialVersionUID = -5527033249080497877L;
    private static final String MODULE_LOCATION_CANNOT_BE_NULL = Messages.getString((String)"ScriptLoader.MODULE_LOCATION_CANNOT_BE_NULL");
    private static final String JS_EXTENSION = ".js";
    private static final String JSLIB_EXTENSION = ".js";
    private AbstractScriptExecutor executor;
    private IRepository repository;
    private String[] rootPaths;

    public RepositoryModuleSourceProvider(AbstractScriptExecutor executor, IRepository repository, String ... rootPaths) {
        this.executor = executor;
        this.repository = repository;
        this.rootPaths = rootPaths;
    }

    public ModuleSource loadSource(String moduleId, Scriptable paths, Object validator) throws IOException, URISyntaxException {
        if (moduleId == null) {
            throw new IOException(MODULE_LOCATION_CANNOT_BE_NULL);
        }
        byte[] sourceCode = null;
        ModuleSource moduleSource = null;
        if (moduleId.endsWith(".js")) {
            sourceCode = this.executor.retrieveModule(this.repository, moduleId, "", this.rootPaths).getContent();
            moduleSource = new ModuleSource((Reader)new InputStreamReader(new ByteArrayInputStream(sourceCode)), null, new URI(moduleId), null, null);
        } else {
            sourceCode = this.executor.retrieveModule(this.repository, moduleId, ".js", this.rootPaths).getContent();
            moduleSource = new ModuleSource((Reader)new InputStreamReader(new ByteArrayInputStream(sourceCode)), null, new URI(String.valueOf(moduleId) + ".js"), null, null);
        }
        return moduleSource;
    }

    protected ModuleSource loadFromUri(URI uri, URI base, Object validator) throws IOException, URISyntaxException {
        return null;
    }
}

