/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DatabaseUpdater;
import org.eclipse.dirigible.repository.ext.db.DsvUpdater;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionUpdater;
import org.eclipse.dirigible.repository.ext.security.SecurityUpdater;
import org.eclipse.dirigible.runtime.job.JobsUpdater;

public class ContentPostImportUpdater {
    private IRepository repository;

    public ContentPostImportUpdater(IRepository repository) {
        this.repository = repository;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void update(HttpServletRequest request) throws IOException, Exception {
        DatabaseUpdater databaseUpdater = new DatabaseUpdater(this.getRepository(), DataSourceFacade.getInstance().getDataSource(request), "/db/dirigible/registry/public/DataStructures");
        databaseUpdater.applyUpdates();
        SecurityUpdater securityUpdater = new SecurityUpdater(this.getRepository(), DataSourceFacade.getInstance().getDataSource(request), "/db/dirigible/registry/public/SecurityConstraints");
        securityUpdater.applyUpdates();
        DsvUpdater dsvUpdater = new DsvUpdater(this.getRepository(), DataSourceFacade.getInstance().getDataSource(request), "/db/dirigible/registry/public/DataStructures");
        dsvUpdater.applyUpdates();
        ExtensionUpdater extensionUpdater = new ExtensionUpdater(this.getRepository(), DataSourceFacade.getInstance().getDataSource(request), "/db/dirigible/registry/public/ExtensionDefinitions", request);
        extensionUpdater.applyUpdates();
        JobsUpdater jobsUpdater = new JobsUpdater(this.getRepository(), DataSourceFacade.getInstance().getDataSource(request), "/db/dirigible/registry/public/IntegrationServices");
        jobsUpdater.applyUpdates();
    }
}

