/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.shared.editor.impl;

import java.net.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;

public class URIEditorInput
implements IURIEditorInput {
    private final URI uri;
    private final String name;
    private final String toolTipText;

    public URIEditorInput(URI uri) {
        this.uri = uri;
        this.name = URIEditorInput.extractNameFromUri(uri);
        this.toolTipText = uri.toString();
    }

    public URIEditorInput(URI uri, String name) {
        this.uri = uri;
        this.name = name;
        this.toolTipText = uri.toString();
    }

    public URIEditorInput(URI uri, String name, String toolTipText) {
        this.uri = uri;
        this.name = name;
        this.toolTipText = toolTipText;
    }

    private static String extractNameFromUri(URI uri) {
        String location = uri.toString();
        int lastSlashIndex = location.lastIndexOf(47);
        if (lastSlashIndex != -1 && lastSlashIndex != location.length() - 1) {
            return location.substring(lastSlashIndex + 1);
        }
        return location;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public URI getURI() {
        return this.uri;
    }
}

